/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.therlink.domain.responses;

import be.ehealth.business.common.domain.Patient;
import be.ehealth.businessconnector.therlink.domain.HcParty;
import be.ehealth.businessconnector.therlink.domain.OperationContext;
import be.ehealth.businessconnector.therlink.domain.TherapeuticLink;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.LocalDate;

public class TherapeuticLinkResponse
extends TherapeuticLink {
    private static final long serialVersionUID = 1L;
    private List<OperationContext> operationContexts;

    public TherapeuticLinkResponse(Patient patient, HcParty hcParty, String type) {
        super(patient, hcParty, type);
    }

    private TherapeuticLinkResponse() {
    }

    public List<OperationContext> getOperationContexts() {
        if (this.operationContexts == null) {
            this.operationContexts = new ArrayList<OperationContext>();
        }
        return this.operationContexts;
    }

    public void setOperationContexts(List<OperationContext> operationContexts) {
        this.operationContexts = operationContexts;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.operationContexts == null ? 0 : ((Object)this.operationContexts).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TherapeuticLinkResponse other = (TherapeuticLinkResponse)obj;
        return !(this.operationContexts == null ? other.operationContexts != null : !((Object)this.operationContexts).equals(other.operationContexts));
    }

    public static class Builder {
        private TherapeuticLinkResponse therlink = new TherapeuticLinkResponse();

        public Builder withPatient(Patient patient) {
            this.therlink.setPatient(patient);
            return this;
        }

        public Builder withHcParty(HcParty hcp) {
            this.therlink.setHcParty(hcp);
            return this;
        }

        public Builder addOperationContext(OperationContext oc) {
            this.therlink.getOperationContexts().add(oc);
            return this;
        }

        public Builder withStartDate(LocalDate startDate) {
            this.therlink.setStartDate(startDate);
            return this;
        }

        public Builder withEndDate(LocalDate endDate) {
            this.therlink.setEndDate(endDate);
            return this;
        }

        public Builder withType(String string) {
            this.therlink.setType(string);
            return this;
        }

        public TherapeuticLinkResponse build() {
            return this.therlink;
        }
    }
}

