/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.gopher;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.AccessController;
import sun.net.NetworkClient;
import sun.net.www.MessageHeader;
import sun.net.www.URLConnection;
import sun.net.www.protocol.gopher.GopherInputStream;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class GopherClient
extends NetworkClient
implements Runnable {
    @Deprecated
    public static boolean useGopherProxy = AccessController.doPrivileged(new GetBooleanAction("gopherProxySet"));
    @Deprecated
    public static String gopherProxyHost = AccessController.doPrivileged(new GetPropertyAction("gopherProxyHost"));
    @Deprecated
    public static int gopherProxyPort = AccessController.doPrivileged(new GetIntegerAction("gopherProxyPort", 80));
    PipedOutputStream os;
    URL u;
    int gtype;
    String gkey;
    URLConnection connection;

    GopherClient(URLConnection connection) {
        this.connection = connection;
    }

    public static boolean getUseGopherProxy() {
        return AccessController.doPrivileged(new GetBooleanAction("gopherProxySet"));
    }

    public static String getGopherProxyHost() {
        String host = AccessController.doPrivileged(new GetPropertyAction("gopherProxyHost"));
        if ("".equals(host)) {
            host = null;
        }
        return host;
    }

    public static int getGopherProxyPort() {
        return AccessController.doPrivileged(new GetIntegerAction("gopherProxyPort", 80));
    }

    InputStream openStream(URL u) throws IOException {
        int i;
        this.u = u;
        this.os = this.os;
        String s = u.getFile();
        int limit = s.length();
        char c = s.charAt(i);
        for (i = 0; i < limit && c == '/'; ++i) {
        }
        int n = this.gtype = c == '/' ? 49 : (int)c;
        if (i < limit) {
            ++i;
        }
        this.gkey = s.substring(i);
        this.openServer(u.getHost(), u.getPort() <= 0 ? 70 : u.getPort());
        MessageHeader msgh = new MessageHeader();
        switch (this.gtype) {
            case 48: 
            case 55: {
                msgh.add("content-type", "text/plain");
                break;
            }
            case 49: {
                msgh.add("content-type", "text/html");
                break;
            }
            case 73: 
            case 103: {
                msgh.add("content-type", "image/gif");
                break;
            }
            default: {
                msgh.add("content-type", "content/unknown");
            }
        }
        i = this.gkey.indexOf(63);
        if (this.gtype != 55) {
            this.serverOutput.print(this.decodePercent(this.gkey) + "\r\n");
            this.serverOutput.flush();
        } else if (i >= 0) {
            this.serverOutput.print(this.decodePercent(this.gkey.substring(0, i) + "\t" + this.gkey.substring(i + 1) + "\r\n"));
            this.serverOutput.flush();
            msgh.add("content-type", "text/html");
        } else {
            msgh.add("content-type", "text/html");
        }
        this.connection.setProperties(msgh);
        if (msgh.findValue("content-type") == "text/html") {
            this.os = new PipedOutputStream();
            PipedInputStream ret = new PipedInputStream();
            ret.connect(this.os);
            new Thread(this).start();
            return ret;
        }
        return new GopherInputStream(this, this.serverInput);
    }

    private String decodePercent(String s) {
        if (s == null || s.indexOf(37) < 0) {
            return s;
        }
        int limit = s.length();
        char[] d = new char[limit];
        int dp = 0;
        for (int sp = 0; sp < limit; ++sp) {
            int c = s.charAt(sp);
            if (c == 37 && sp + 2 < limit) {
                int s1 = s.charAt(sp + 1);
                int s2 = s.charAt(sp + 2);
                s1 = 48 <= s1 && s1 <= 57 ? (s1 -= 48) : (97 <= s1 && s1 <= 102 ? s1 - 97 + 10 : (65 <= s1 && s1 <= 70 ? s1 - 65 + 10 : -1));
                s2 = 48 <= s2 && s2 <= 57 ? (s2 -= 48) : (97 <= s2 && s2 <= 102 ? s2 - 97 + 10 : (65 <= s2 && s2 <= 70 ? s2 - 65 + 10 : -1));
                if (s1 >= 0 && s2 >= 0) {
                    c = s1 << 4 | s2;
                    sp += 2;
                }
            }
            d[dp++] = (char)c;
        }
        return new String(d, 0, dp);
    }

    private String encodePercent(String s) {
        if (s == null) {
            return s;
        }
        int limit = s.length();
        char[] d = null;
        int dp = 0;
        for (int sp = 0; sp < limit; ++sp) {
            char c = s.charAt(sp);
            if (c <= ' ' || c == '\"' || c == '%') {
                if (d == null) {
                    d = s.toCharArray();
                }
                if (dp + 3 >= d.length) {
                    char[] nd = new char[dp + 10];
                    System.arraycopy(d, 0, nd, 0, dp);
                    d = nd;
                }
                d[dp] = 37;
                int dig = c >> 4 & 0xF;
                d[dp + 1] = (char)(dig < 10 ? 48 + dig : 55 + dig);
                dig = c & 0xF;
                d[dp + 2] = (char)(dig < 10 ? 48 + dig : 55 + dig);
                dp += 3;
                continue;
            }
            if (d != null) {
                if (dp >= d.length) {
                    char[] nd = new char[dp + 10];
                    System.arraycopy(d, 0, nd, 0, dp);
                    d = nd;
                }
                d[dp] = c;
            }
            ++dp;
        }
        return d == null ? s : new String(d, 0, dp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block24: {
            try {
                String s;
                int qpos = this.gkey.indexOf(63);
                if (this.gtype == 55 && qpos < 0) {
                    PrintStream ps = new PrintStream((OutputStream)this.os, false, encoding);
                    ps.print("<html><head><title>Searchable Gopher Index</title></head>\n<body><h1>Searchable Gopher Index</h1><isindex>\n</body></html>\n");
                    break block24;
                }
                if (this.gtype != 49 && this.gtype != 55) {
                    byte[] buf = new byte[2048];
                    try {
                        int n;
                        while ((n = this.serverInput.read(buf)) >= 0) {
                            this.os.write(buf, 0, n);
                        }
                        break block24;
                    }
                    catch (Exception n) {
                        break block24;
                    }
                }
                PrintStream ps = new PrintStream((OutputStream)this.os, false, encoding);
                String title = null;
                title = this.gtype == 55 ? "Results of searching for \"" + this.gkey.substring(qpos + 1) + "\" on " + this.u.getHost() : "Gopher directory " + this.gkey + " from " + this.u.getHost();
                ps.print("<html><head><title>");
                ps.print(title);
                ps.print("</title></head>\n<body>\n<H1>");
                ps.print(title);
                ps.print("</h1><dl compact>\n");
                DataInputStream ds = new DataInputStream(this.serverInput);
                while ((s = ds.readLine()) != null) {
                    int len;
                    for (len = s.length(); len > 0 && s.charAt(len - 1) <= ' '; --len) {
                    }
                    if (len <= 0) continue;
                    char key = s.charAt(0);
                    int t1 = s.indexOf(9);
                    int t2 = t1 > 0 ? s.indexOf(9, t1 + 1) : -1;
                    int t3 = t2 > 0 ? s.indexOf(9, t2 + 1) : -1;
                    if (t3 < 0) continue;
                    String port = t3 + 1 < len ? ":" + s.substring(t3 + 1, len) : "";
                    String host = t2 + 1 < t3 ? s.substring(t2 + 1, t3) : this.u.getHost();
                    ps.print("<dt><a href=\"gopher://" + host + port + "/" + s.substring(0, 1) + this.encodePercent(s.substring(t1 + 1, t2)) + "\">\n");
                    ps.print("<img align=middle border=0 width=25 height=32 src=");
                    switch (key) {
                        default: {
                            ps.print(System.getProperty("java.net.ftp.imagepath.file"));
                            break;
                        }
                        case '0': {
                            ps.print(System.getProperty("java.net.ftp.imagepath.text"));
                            break;
                        }
                        case '1': {
                            ps.print(System.getProperty("java.net.ftp.imagepath.directory"));
                            break;
                        }
                        case 'g': {
                            ps.print(System.getProperty("java.net.ftp.imagepath.gif"));
                        }
                    }
                    ps.print(".gif align=middle><dd>\n");
                    ps.print(s.substring(1, t1) + "</a>\n");
                }
                ps.print("</dl></body>\n");
                ps.close();
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalError(encoding + " encoding not found");
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.closeServer();
                    this.os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

