/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.jca;

import be.fedict.commons.eid.jca.BeIDKeyManagerFactory;
import be.fedict.commons.eid.jca.BeIDKeyStore;
import be.fedict.commons.eid.jca.BeIDPrivateKey;
import be.fedict.commons.eid.jca.BeIDSecureRandom;
import be.fedict.commons.eid.jca.BeIDSignature;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeIDProvider
extends Provider {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "BeIDProvider";
    private static final Log LOG = LogFactory.getLog(BeIDProvider.class);

    public BeIDProvider() {
        super(NAME, 1.0, "BeID Provider");
        this.putService(new BeIDService(this, "KeyStore", "BeID", BeIDKeyStore.class.getName()));
        HashMap<String, String> signatureServiceAttributes = new HashMap<String, String>();
        signatureServiceAttributes.put("SupportedKeyClasses", BeIDPrivateKey.class.getName());
        this.putService(new BeIDService(this, "Signature", "SHA1withRSA", BeIDSignature.class.getName(), signatureServiceAttributes));
        this.putService(new BeIDService(this, "Signature", "SHA224withRSA", BeIDSignature.class.getName(), signatureServiceAttributes));
        this.putService(new BeIDService(this, "Signature", "SHA256withRSA", BeIDSignature.class.getName(), signatureServiceAttributes));
        this.putService(new BeIDService(this, "Signature", "SHA384withRSA", BeIDSignature.class.getName(), signatureServiceAttributes));
        this.putService(new BeIDService(this, "Signature", "SHA512withRSA", BeIDSignature.class.getName(), signatureServiceAttributes));
        this.putService(new BeIDService(this, "Signature", "NONEwithRSA", BeIDSignature.class.getName(), signatureServiceAttributes));
        this.putService(new BeIDService(this, "Signature", "RIPEMD128withRSA", BeIDSignature.class.getName(), signatureServiceAttributes));
        this.putService(new BeIDService(this, "Signature", "RIPEMD160withRSA", BeIDSignature.class.getName(), signatureServiceAttributes));
        this.putService(new BeIDService(this, "Signature", "RIPEMD256withRSA", BeIDSignature.class.getName(), signatureServiceAttributes));
        this.putService(new BeIDService(this, "Signature", "SHA1withRSAandMGF1", BeIDSignature.class.getName(), signatureServiceAttributes));
        this.putService(new BeIDService(this, "Signature", "SHA256withRSAandMGF1", BeIDSignature.class.getName(), signatureServiceAttributes));
        this.putService(new BeIDService(this, "KeyManagerFactory", "BeID", BeIDKeyManagerFactory.class.getName()));
        this.putService(new BeIDService(this, "SecureRandom", "BeID", BeIDSecureRandom.class.getName()));
    }

    private static final class BeIDService
    extends Provider.Service {
        public BeIDService(Provider provider, String type, String algorithm, String className) {
            super(provider, type, algorithm, className, null, null);
        }

        public BeIDService(Provider provider, String type, String algorithm, String className, Map<String, String> attributes) {
            super(provider, type, algorithm, className, null, attributes);
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            LOG.debug((Object)("newInstance: " + super.getType()));
            if (super.getType().equals("Signature")) {
                return new BeIDSignature(this.getAlgorithm());
            }
            return super.newInstance(constructorParameter);
        }

        @Override
        public boolean supportsParameter(Object parameter) {
            LOG.debug((Object)("supportedParameter: " + parameter));
            return super.supportsParameter(parameter);
        }
    }
}

