/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.ws.feature;

import be.ehealth.technicalconnector.ws.feature.GenericFeature;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSigningFeature
extends GenericFeature {
    public static final String ID = "be.ehealth.technicalconnector.ws.feature.signing";
    public static final String EC_SIGNATURE_METHOD_ALGORITHM = "ec.signature.method.algorithm";
    public static final String RSA_SIGNATURE_METHOD_ALGORITHM = "rsa.signature.method.algorithm";
    public static final String DIGEST_METHOD_ALGORITHM = "digest.method.algorithm";

    public AbstractSigningFeature() {
        super(true);
    }

    @Override
    public String getID() {
        return ID;
    }

    abstract String getSignatureRSAMethodAlgorithm();

    abstract String getSignatureECMethodAlgorithm();

    abstract String getDigestMethodAlgorithm();

    @Override
    public Map<String, Object> requestParamOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(ID, "true");
        options.putAll(this.add(RSA_SIGNATURE_METHOD_ALGORITHM, this.getSignatureRSAMethodAlgorithm()));
        options.putAll(this.add(EC_SIGNATURE_METHOD_ALGORITHM, this.getSignatureECMethodAlgorithm()));
        options.putAll(this.add(DIGEST_METHOD_ALGORITHM, this.getDigestMethodAlgorithm()));
        return options;
    }

    private Map<String, Object> add(String key, String value) {
        HashMap<String, Object> option = new HashMap<String, Object>();
        if (value != null) {
            option.put(key, value);
        }
        return option;
    }
}

