/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.shutdown;

import be.ehealth.technicalconnector.shutdown.ShutdownHook;
import java.util.ArrayList;
import java.util.List;

public class ShutdownRegistry {
    private static final String SHUTDOWNHOOK_ACTIVATED = "be.ehealth.technicalconnector.shutdown.runtime.shutdownhook";

    private ShutdownRegistry() {
    }

    public static void register(ShutdownHook hook) {
        ShutdownRegistryEnum.INSTANCE.register(hook);
    }

    public static void shutdown() {
        ShutdownRegistryEnum.INSTANCE.shutdown();
    }

    static enum ShutdownRegistryEnum {
        INSTANCE(new ArrayList<ShutdownHook>());

        private List<ShutdownHook> registry;

        private ShutdownRegistryEnum(List<ShutdownHook> registry) {
            this.registry = registry;
            if (Boolean.parseBoolean(System.getProperty(ShutdownRegistry.SHUTDOWNHOOK_ACTIVATED, "true"))) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        ShutdownRegistryEnum.this.shutdown();
                    }
                });
            }
        }

        void register(ShutdownHook hook) {
            this.registry.add(hook);
        }

        void shutdown() {
            for (ShutdownHook hook : this.registry) {
                hook.shutdown();
            }
        }
    }
}

