/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma;

import fr.xebia.extras.selma.SelmaException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Selma {
    public static final String SET_CUSTOM_MAPPER = "setCustomMapper";
    public static final String SET_FACTORY = "setFactory";
    private static final ConcurrentMap<MapperKey, Object> mappers = new ConcurrentHashMap<MapperKey, Object>();

    public static <T> MapperBuilder<T> builder(Class<T> mapperClass) {
        return new MapperBuilder(mapperClass);
    }

    public static <T> T mapper(Class<T> mapperClass) throws IllegalArgumentException {
        return Selma.getMapper(mapperClass, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public static <T> T mapper(Class<T> mapperClass, Object source) {
        return Selma.getMapper(mapperClass, source, null);
    }

    public static <T> T getMapper(Class<T> mapperClass) {
        return Selma.getMapper(mapperClass, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public static <T> T getMapperWithCustom(Class<T> mapperClass, Object custom) {
        return Selma.getMapper(mapperClass, null, custom);
    }

    public static <T> T getMapper(Class<T> mapperClass, Object source, Object customMapper) throws IllegalArgumentException {
        return Selma.getMapper(mapperClass, source == null ? Collections.EMPTY_LIST : Collections.singletonList(source), customMapper == null ? Collections.EMPTY_LIST : Collections.singletonList(customMapper));
    }

    private static <T> T getMapper(Class<T> mapperClass, List source, List customMappers) throws IllegalArgumentException {
        return Selma.getMapper(mapperClass, source, customMappers, true, Collections.EMPTY_LIST);
    }

    private static <T> T getMapper(Class<T> mapperClass, List source, List customMappers, boolean useCache, List factories) throws IllegalArgumentException {
        Object prev;
        if (!useCache) {
            return (T)Selma.createMapperInstance(mapperClass, source, customMappers, factories);
        }
        MapperKey mapperKey = new MapperKey(mapperClass, source, customMappers, factories);
        Object mapperInstance = mappers.get(mapperKey);
        if (mapperInstance == null && (prev = mappers.putIfAbsent(mapperKey, mapperInstance = Selma.createMapperInstance(mapperClass, source, customMappers, factories))) != null) {
            mapperInstance = prev;
        }
        return (T)mapperInstance;
    }

    private static <T> Object createMapperInstance(Class<T> mapperClass, List source, List customMappers, List factories) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = Selma.class.getClassLoader();
        }
        String generatedClassName = mapperClass.getCanonicalName() + "SelmaGeneratedClass";
        try {
            Class<?>[] classes;
            Class<?>[] interfaces;
            Class<?> classe;
            Method method;
            Class<?> mapperImpl = classLoader.loadClass(generatedClassName);
            if (!mapperClass.isAssignableFrom(mapperImpl)) {
                throw new IllegalStateException("Mapper class " + mapperImpl.getCanonicalName() + " does not implement/extend " + mapperClass.getCanonicalName());
            }
            if (mapperImpl.getConstructors().length != 1) {
                throw new IllegalArgumentException("Mapper class " + mapperImpl.getCanonicalName() + " should have 1 constructor !");
            }
            Constructor<?> retainedConstructor = mapperImpl.getConstructors()[0];
            if (retainedConstructor.getParameterTypes().length != source.size()) {
                throw new IllegalArgumentException("Mapper class " + mapperImpl.getCanonicalName() + " constructor needs a source " + retainedConstructor.toString());
            }
            Object mapperInstance = source.size() > 0 ? retainedConstructor.newInstance(source.toArray()) : mapperImpl.newInstance();
            for (Object factory : factories) {
                if (factory == null) continue;
                Class<?> factoryClass = factory.getClass();
                method = null;
                classe = factoryClass;
                while (method == null && !Object.class.equals(classe)) {
                    interfaces = classe.getInterfaces();
                    classes = Arrays.copyOf(interfaces, interfaces.length + 1);
                    classes[interfaces.length] = classe;
                    method = Selma.getSetFactoryMethodFor(generatedClassName, mapperImpl, factoryClass, classes);
                    classe = classe.getSuperclass();
                }
                if (method != null) {
                    method.invoke(mapperInstance, factory);
                    continue;
                }
                throw new IllegalArgumentException("given a Factory of type " + factoryClass.getSimpleName() + " while setter does not exist, add it to @Mapper interface");
            }
            for (Object customMapper : customMappers) {
                if (customMapper == null) continue;
                Class<?> customMapperClass = customMapper.getClass();
                method = null;
                classe = customMapperClass;
                while (method == null && !Object.class.equals(classe)) {
                    interfaces = classe.getInterfaces();
                    classes = Arrays.copyOf(interfaces, interfaces.length + 1);
                    classes[interfaces.length] = classe;
                    method = Selma.getSetCustomMapperMethodFor(generatedClassName, mapperImpl, customMapperClass, classes);
                    classe = classe.getSuperclass();
                }
                if (method != null) {
                    method.invoke(mapperInstance, customMapper);
                    continue;
                }
                throw new IllegalArgumentException("given a CustomMapper of type " + customMapperClass.getSimpleName() + " while setter does not exist, add it to @Mapper interface");
            }
            return mapperInstance;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(String.format("Instantiation of Mapper class %s failed : %s", generatedClassName, e.getMessage()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Instantiation of Mapper class %s failed : %s", generatedClassName, e.getMessage()), e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Unable to load generated mapper class %s failed : %s", generatedClassName, e.getMessage()), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Instantiation of Mapper class %s failed (No constructor with %s parameter !) : %s", generatedClassName, source.getClass().getSimpleName(), e.getMessage()), e);
        }
    }

    private static <T> Method getSetCustomMapperMethodFor(String generatedClassName, Class<T> mapperImpl, Class<?> customMapperClass, Class<?> ... classes) {
        return Selma.getSetMethodFor(SET_CUSTOM_MAPPER, "custom mapper", generatedClassName, mapperImpl, customMapperClass, classes);
    }

    private static <T> Method getSetFactoryMethodFor(String generatedClassName, Class<T> mapperImpl, Class<?> factoryClass, Class<?> ... classes) {
        return Selma.getSetMethodFor(SET_FACTORY, "factory", generatedClassName, mapperImpl, factoryClass, classes);
    }

    private static <T> Method getSetMethodFor(String prefix, String type, String generatedClassName, Class<T> mapperImpl, Class<?> customClass, Class<?> ... classes) {
        Method method = null;
        for (Class<?> classe : classes) {
            String setter = prefix + classe.getSimpleName();
            try {
                method = mapperImpl.getMethod(setter, classe);
                break;
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
                throw new SelmaException(e, "Setter for %s %s named %s not accessible in %s", type, customClass, setter, generatedClassName);
            }
        }
        return method;
    }

    public static class MapperBuilder<T> {
        private final Class<T> mapperClass;
        private final List customMappers;
        private final List sources;
        private final boolean cache;
        private final List factories;

        private MapperBuilder(Class<T> mapperClass) {
            this.mapperClass = mapperClass;
            this.customMappers = Collections.EMPTY_LIST;
            this.sources = Collections.EMPTY_LIST;
            this.cache = true;
            this.factories = Collections.EMPTY_LIST;
        }

        private MapperBuilder(Class<T> mapperClass, List sources, List customMappers, boolean cache, List factories) {
            this.mapperClass = mapperClass;
            this.sources = sources;
            this.customMappers = customMappers;
            this.cache = cache;
            this.factories = factories;
        }

        public T build() {
            Object res = Selma.getMapper(this.mapperClass, this.sources, this.customMappers, this.cache, this.factories);
            return (T)res;
        }

        public MapperBuilder<T> withCustom(Object ... customMapper) {
            return new MapperBuilder<T>(this.mapperClass, this.sources, Arrays.asList(customMapper), this.cache, this.factories);
        }

        public MapperBuilder<T> withSources(Object ... dataSource) {
            return new MapperBuilder<T>(this.mapperClass, Arrays.asList(dataSource), this.customMappers, this.cache, this.factories);
        }

        public MapperBuilder<T> disableCache() {
            return new MapperBuilder<T>(this.mapperClass, this.sources, this.customMappers, false, this.factories);
        }

        public MapperBuilder<T> withFactories(Object ... factories) {
            return new MapperBuilder<T>(this.mapperClass, this.sources, this.customMappers, this.cache, Arrays.asList(factories));
        }
    }

    private static class MapperKey {
        private final Class mapperClass;
        private final List source;
        private final List customMappers;
        private final List factories;

        MapperKey(Class mapperClass, List source, List customMappers, List factories) {
            this.customMappers = customMappers;
            this.mapperClass = mapperClass;
            this.source = source;
            this.factories = factories;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MapperKey that = (MapperKey)obj;
            return this.mapperClass.equals(that.mapperClass) && this.source.equals(that.source) && this.customMappers.equals(that.customMappers) && this.factories.equals(that.factories);
        }

        public int hashCode() {
            int result = this.mapperClass.hashCode();
            result = 31 * result + this.source.hashCode();
            result = 31 * result + this.customMappers.hashCode();
            result = 31 * result + this.factories.hashCode();
            return result;
        }
    }
}

