/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.utils;

import be.fgov.ehealth.etee.crypto.utils.KeyManager;
import java.security.KeyStore;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.Collection;

public final class CertStringBuilder {
    private CertStringBuilder() {
    }

    public static String build(KeyStore certificates) {
        return CertStringBuilder.build(KeyManager.getCertificates(certificates));
    }

    public static String build(CertPath certPath) {
        return CertStringBuilder.build(certPath.getCertificates());
    }

    public static String build(Collection<X509Certificate> certificates) {
        if (certificates.isEmpty()) {
            return "<empty list>";
        }
        StringBuffer sb = new StringBuffer();
        for (X509Certificate cert : certificates) {
            sb.append(CertStringBuilder.build(cert)).append(", ");
        }
        return sb.toString();
    }

    public static String build(X509Certificate certificate) {
        return CertStringBuilder.build(certificate, true);
    }

    public static String build(X509Certificate certificate, boolean details) {
        StringBuffer sb = new StringBuffer("X.509 Certificate [");
        if (certificate != null) {
            sb.append("SerialNumber=").append(certificate.getSerialNumber());
            if (details) {
                sb.append(", Subject=").append(certificate.getSubjectX500Principal().toString());
                sb.append(", NotAfter=").append(certificate.getNotAfter());
                sb.append(", Issuer=").append(certificate.getIssuerX500Principal().toString());
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

