/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.cert.CertPathChecker;
import be.fgov.ehealth.etee.crypto.decrypt.CMSMessageContext;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataNotification;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierAbstract;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierData;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierResult;
import be.fgov.ehealth.etee.crypto.decrypt.SignerInfoAttributes;
import be.fgov.ehealth.etee.crypto.decrypt.SignerInfoAttributesReceiver;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPChecker;
import be.fgov.ehealth.etee.crypto.policies.SignatureLayer;
import be.fgov.ehealth.etee.crypto.policies.SigningCredential;
import be.fgov.ehealth.etee.crypto.policies.SigningPolicy;
import be.fgov.ehealth.etee.crypto.status.CryptoResult;
import be.fgov.ehealth.etee.crypto.status.NotificationError;
import be.fgov.ehealth.etee.crypto.utils.DistinguishedName;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SignedDataVerifierInner
extends SignedDataVerifierAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignedDataVerifierInner.class);

    public SignedDataVerifierInner(Collection<SigningPolicy> signingPolicies, int[] requiredKeyUsage, OCSPChecker ocspChecker, CertPathChecker certPathChecker, SignerInfoAttributesReceiver signerInfoAttributesReceiver) {
        super(SignatureLayer.INNER, signingPolicies, requiredKeyUsage, ocspChecker, certPathChecker, signerInfoAttributesReceiver);
    }

    @Override
    public CryptoResult<SignedDataVerifierData> verifySignedData(CMSMessageContext<?> cmsMsgContext, SignedDataVerifierData outerVerificationData, SigningCredential ... signers) {
        SignedDataVerifierResult result = new SignedDataVerifierResult();
        SigningPolicy actualSigningPolicy = outerVerificationData.getSigningPolicy();
        SignerInformation signerInformation = cmsMsgContext.getSignerInformation();
        if (!cmsMsgContext.isStreamingMode()) {
            result.setContent(cmsMsgContext.getContentStream());
        }
        result.setSignerInformation(signerInformation);
        result.setSignature(signerInformation.getSignature());
        SigningPolicy signingPolicy = this.definePolicy(signerInformation);
        result.setSigningPolicy(signingPolicy);
        this.verifyAlgorithmsUsed(result, signerInformation, signingPolicy);
        result.setSigningPolicy(signingPolicy);
        actualSigningPolicy = this.defineSigningPolicy(result, signingPolicy, actualSigningPolicy);
        SignerInfoAttributes signerInfoAttributes = this.getSignerInfoAttributes(result, signerInformation);
        if (signingPolicy == SigningPolicy.WEB_AUTHN) {
            String subjectKeyIdentifier = this.getSubjectKeyIdentifier(cmsMsgContext);
            result.setSignatureKeyIdentifier(subjectKeyIdentifier);
            if (subjectKeyIdentifier == null) {
                LOGGER.warn(this.buildMsg("No SubjectKeyIdentifier available."));
                result.getErrors().add(SignedDataNotification.SUBJECT_KEY_IDENTIFIER_EXPECTED_BUT_NOT_PRESENT.get(this.getLayer()));
            } else {
                LOGGER.info("Message Author: PublicKey [" + subjectKeyIdentifier + "]");
                this.verifyPublicKey(result, cmsMsgContext, subjectKeyIdentifier, signerInfoAttributes, signingPolicy, signers);
                this.verifyMessageIntegrity(result, outerVerificationData.getSignerInformation().getSID(), signerInformation.getSID());
            }
        } else {
            X509Certificate signerCertificate = cmsMsgContext.getAuthenticationCertificate();
            result.setSignatureCert(signerCertificate);
            if (signerCertificate == null) {
                LOGGER.info("Message Author: [no cert available]");
                if (outerVerificationData.getAuthenticationCert() != null) {
                    LOGGER.debug(this.buildMsg("Verify inner signature with outer certificate: " + outerVerificationData.getAuthenticationCert().getSubjectX500Principal()));
                    this.verifySignature(result, signerInformation, outerVerificationData.getAuthenticationCert());
                    this.verifyCertificateKeyUsage(result, outerVerificationData.getAuthenticationCert());
                    if (signers != null && signers.length > 0) {
                        this.verifySigner(result, outerVerificationData.getAuthenticationCert(), signers);
                    }
                }
                return result;
            }
            LOGGER.info("Author: X.509 Certificate [" + signerCertificate.getSerialNumber() + "]");
            if (signers != null && signers.length > 0) {
                this.verifySigner(result, signerCertificate, signers);
            }
            if (outerVerificationData.getAuthenticationCert() != null) {
                this.verifyMessageIntegrity(result, outerVerificationData.getAuthenticationCert(), signerCertificate);
            }
            this.verifyCertificate(result, cmsMsgContext, signerInfoAttributes, outerVerificationData.getSigningTime(), actualSigningPolicy);
        }
        return result;
    }

    private SigningPolicy defineSigningPolicy(SignedDataVerifierResult result, SigningPolicy innerSigningPolicy, SigningPolicy outerSigningPolicy) {
        if (outerSigningPolicy == null) {
            return innerSigningPolicy;
        }
        if (innerSigningPolicy == null) {
            return outerSigningPolicy;
        }
        if (!outerSigningPolicy.equals((Object)innerSigningPolicy)) {
            LOGGER.error(this.buildMsg("Different policies found for inner and outer signature: " + (Object)((Object)outerSigningPolicy) + " - " + (Object)((Object)innerSigningPolicy)));
            result.getErrors().add(NotificationError.MESSAGE_INTEGRITY_INVALID);
        }
        return outerSigningPolicy;
    }

    private void verifyMessageIntegrity(SignedDataVerifierResult result, X509Certificate outer, X509Certificate inner) {
        if (!this.checkCertificateCorrelation(outer, inner)) {
            result.getErrors().add(NotificationError.MESSAGE_INTEGRITY_INVALID);
        }
    }

    private void verifyMessageIntegrity(SignedDataVerifierResult result, SignerId outer, SignerId inner) {
        if (!this.checkSubjectKeyCorrelation(outer, inner)) {
            result.getErrors().add(NotificationError.MESSAGE_INTEGRITY_INVALID);
        }
    }

    private boolean checkSubjectKeyCorrelation(SignerId outer, SignerId inner) {
        return outer != null && inner != null && outer.getSubjectKeyIdentifier() != null && inner.getSubjectKeyIdentifier() != null && Arrays.equals(outer.getSubjectKeyIdentifier(), inner.getSubjectKeyIdentifier());
    }

    private boolean checkCertificateCorrelation(X509Certificate outer, X509Certificate inner) {
        LOGGER.debug("Verify correlation between inner and outer certificate.");
        DistinguishedName outerDN = DistinguishedName.from(outer.getSubjectX500Principal());
        DistinguishedName innerDN = DistinguishedName.from(inner.getSubjectX500Principal());
        if (!outerDN.hasSerialNumber() && !innerDN.hasSerialNumber()) {
            LOGGER.warn("Certificates have no serialnumber. Subject must be same.");
            return outer.getSubjectX500Principal().equals(inner.getSubjectX500Principal());
        }
        if (outerDN.hasSerialNumber() && outerDN.getSerialNumber().equals(innerDN.getSerialNumber())) {
            LOGGER.debug("Sender = Author [X.509 Certificate SerialNumber=" + outerDN.getSerialNumber() + "]");
            return true;
        }
        LOGGER.warn(String.format("SerialNumbers certificates do not match: " + outerDN.getSerialNumber() + " - " + innerDN.getSerialNumber(), new Object[0]));
        return false;
    }
}

