using be.fgov.ehealth.etee.crypto.policies;
using java.security;

#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

namespace be.ehealth.technicalconnector.utils.impl
{
	using System;

	using be.ehealth.technicalconnector.config;
	using be.ehealth.technicalconnector.service.etee;
	using be.ehealth.technicalconnector.service.etee.impl;
	using be.ehealth.technicalconnector.service.sts.security.impl;
	using be.ehealth.technicalconnector.utils.impl;

	using java.util;

	using NUnit.Framework;

	[TestFixture]
	public class OcspRevocationStatusCheckerUserIntegrationTest
	{
		#region Methods
		[SetUp]
		public void before() {
			KeyStore store = (KeyStore) CryptoFactory.getOCSPOptions().get(OCSPOption.TRUST_STORE);
			store.setCertificateEntry("ca", BeIDCredential.getInstance("test", BeIDCredential.EID_AUTH_ALIAS).getCertificateChain()[1]);
			store.setCertificateEntry("ca2", BeIDCredential.getInstance("test", BeIDCredential.EID_AUTH_ALIAS).getCertificateChain()[2]);
		}


		[TearDown]
		public void after() {
			KeyStore store = (KeyStore) CryptoFactory.getOCSPOptions().get(OCSPOption.TRUST_STORE);
			store.deleteEntry("ca");
			store.deleteEntry("ca2");
		}

		
		
		/**
		 * Tests RevocationStatusChecker with the ID card
		 * <b>Requires an ID card</b>
		 * @throws Exception
		 */
		[Test]
		public void testWithEid()
		{
			ConnectorRevocationStatusChecker checker = new ConnectorRevocationStatusChecker();
			bool isRevoked = checker.isRevoked(BeIDCredential.getInstance("test", BeIDCredential.EID_AUTH_ALIAS).getCertificate());
			Assert.IsFalse(isRevoked, "Certificate is revoked.");
		}

		#endregion Methods
	}
}