﻿/*
 * Created by SharpDevelop.
 * User: EH062
 * Date: 17/02/2020
 * Time: 15:22
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using be.ehealth.businessconnector.testcommons.utils;
using be.ehealth.technicalconnector.idgenerator;
using ikvm.extensions;
using org.apache.commons.lang;
using org.joda.time;
using java.util;
using java.lang;

namespace be.ehealth.businessconnector.consultrnv2.session.support
{
	public class RequestTransformer
	{
		public T transform<T>(string fileLocation, Class clazz) {
	        Map velocityContext = new HashMap();
	        velocityContext.put("issueInstant", org.joda.time.format.DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'+02:00'").print(new org.joda.time.DateTime()));
	        velocityContext.put("requestId", IdGeneratorFactory.getIdGenerator("uuid").generateId());
	        velocityContext.put("currentDate", org.joda.time.format.DateTimeFormat.forPattern("yyyy-MM-dd").print(new org.joda.time.DateTime()));
	        velocityContext.put("generatedChars1", RandomStringUtils.randomAlphabetic(10).ToLower());
	        velocityContext.put("generatedChars2", RandomStringUtils.randomAlphabetic(10).ToLower());
	        velocityContext.put("variableName", generateVariableName());
	        return (T) FileTestUtils.toObject(velocityContext, fileLocation, clazz);
	    }
		
		private string generateVariableName() {
			string validChars = "ABCDEFGHIJKLMNOPQRSTUVWCYZ";
	        string variableName = "";
	        int variableNameLength = 13;
	        java.util.Random random = new java.util.Random();
	        
	        for (int i=0; i<variableNameLength; ++i) {
	            int index = java.lang.Math.abs(random.nextInt() % validChars.Length);
	            variableName += validChars.charAt(index);
	        }
	        
	        return variableName;
	    }
	}
}
