using be.fgov.ehealth.etee.crypto.status;
using be.fgov.ehealth.technicalconnector.session;
using be.fgov.ehealth.technicalconnector.tests.utils;

#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

namespace be.ehealth.technicalconnector.utils.impl
{
	using System;

	using be.ehealth.technicalconnector.config;
	using be.ehealth.technicalconnector.service.etee;
	using be.ehealth.technicalconnector.service.etee.impl;
	using be.ehealth.technicalconnector.service.sts.security.impl;
	using be.ehealth.technicalconnector.utils.impl;
	using be.fgov.ehealth.technicalconnector.tests.utils.net;

	using java.util;

	using NUnit.Framework;

	/**
	 * Integration test for {@link OcspRevocationStatusChecker}
	 *
	 */
	[TestFixture]
	public class OcspRevocationStatusCheckerIntegrationTest
	{
		private static Properties props;
		
		[SetUp]
		public static void init() {
			SessionInitializer.init(true);
			props = TestPropertiesNetLoader.getProperties("be.ehealth.technicalconnector.test.properties",SupportedLanguages.NET.getAbbreviation());
		}

		#region Methods

		/**
		 * Tests RevocationStatusChecker with keystore credential (from ehealth certificate)
		 */
		[Test]
		public void testWithKeyStoreCredential() {
			string eHealthCertAlias = props.getProperty("test.keystore.alias");
			string eHealthCertificate = props.getProperty("test.keystore.location");
			string eHealthCertPassword = props.getProperty("test.keystore.password");

			ConnectorRevocationStatusChecker checker = new ConnectorRevocationStatusChecker();
			KeyStoreCredential credential = new KeyStoreCredential(eHealthCertificate, eHealthCertAlias, eHealthCertPassword);
			bool isRevoked = checker.isRevoked(credential.getCertificate());
			Assert.IsFalse(isRevoked);
		}

		#endregion Methods
	}
}