﻿/*
 * Copyright (c) eHealth
 */

using System;
using be.ehealth.businessconnector.dicsv4.exception;
using be.ehealth.technicalconnector.idgenerator;
using be.fgov.ehealth.commons.core.v2;
using be.fgov.ehealth.dics.protocol.v4;
using ikvm.extensions;
using NUnit.Framework;
using java.io;
using java.util;
using java.lang;
using org.apache.commons.lang3;
using org.joda.time;
using org.joda.time.format;
using org.slf4j;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.ehealth.businessconnector.testcommons.utils;

/**
 * Integration tests for tarification.
 * 
 * @author eHealth Platform
 * 
 */
namespace be.ehealth.businessconnector.dicsv4.session
{
public class DicsIntegrationTest {
	    
    [SetUpAttribute]
    public static void setupsession() {
    	SessionInitializer.init(".\\be.ehealth.businessconnector.dicsv4.test.properties",true, SupportedLanguages.NET.getAbbreviation());
    }

    [TearDownAttribute]
    public static void teardownSession() {
        Session.getInstance().unloadSession();
    }

    [Test]
    public void findAmpTestXml() {
        FindAmpResponse response = findAmpTest(".\\examples\\request\\findAmpRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findAmpResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    [Test]
    public void findCompanyXml() {
        FindCompanyResponse response = findCompany(".\\examples\\request\\findCompanyRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findCompanyResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    [Test]
    public void findReferencesXml() {
        FindReferencesResponse response = findReferences(".\\examples\\request\\findReferencesRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findReferencesResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    [Test]
    public void findVmpGroupXml() {
        FindVmpGroupResponse response = findVmpGroup(".\\examples\\request\\findVmpGroupRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findVmpGroupResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    [Test]
    public void findVmpXml() {
        FindVmpResponse response = findVmp(".\\examples\\request\\findVmpRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findVmpResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    [Test]
    public void findVtmXml() {
        FindVtmResponse response = findVtm(".\\examples\\request\\findVtmRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findVtmResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    [Test]
    public void findNonMedicinalProductTest() {
        FindNonMedicinalProductResponse response = findNonMedicinalProduct(".\\examples\\request\\findNonMedicinalProductRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findNonMedicinalProductResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    [Test]
    public void getListOfActualMedicinalProductPackagesXml() {
        GetListOfActualMedicinalProductPackagesResponse response = getListOfActualMedicinalProductPackages(".\\examples\\request\\GetListOfActualMedicinalProductPackagesRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\GetListOfActualMedicinalProductPackagesResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    [Test]
    public void getListOfActualMedicinalProductsXml() {
        GetListOfActualMedicinalProductsResponse response = getListOfActualMedicinalProducts(".\\examples\\request\\GetListOfActualMedicinalProductsRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\GetListOfActualMedicinalProductsResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    [Test]
    public void getListOfVirtualMedicinalProductsXml() {
        GetListOfVirtualMedicinalProductsResponse response = getListOfVirtualMedicinalProducts(".\\examples\\request\\GetListOfVirtualMedicinalProductsRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\GetListOfVirtualMedicinalProductsResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    [Test]
    public void getListOfVmpGroupsXml() {
        GetListOfVmpGroupsResponse response = getListOfVmpGroups(".\\examples\\request\\GetListOfVmpGroupsRequest.xml");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\GetListOfVmpGroupsResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    [Test]
    public void findAmpTestXmlNoDataFound() {
        try {
            findAmpTest(".\\examples\\request\\findAmpRequest-noDataFound.xml");
            Assert.Fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.IsTrue(e.getAnomalies().size() > 0, "No anomaly found");
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findAmpResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    [Test]
    public void findCommentedClassificationXmlNoDataFound() {
        try {
            findCommentedClassification(".\\examples\\request\\findCommentedClassificationRequest-noDataFound.xml");
            Assert.Fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.IsTrue(e.getAnomalies().size() > 0, "No anomaly found");
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findCommentedClassificationResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    [Test]
    public void findCompanyXmlNoDataFound() {
        try {
            findCompany(".\\examples\\request\\findCompanyRequest-noDataFound.xml");
            Assert.Fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.IsTrue(e.getAnomalies().size() > 0, "No anomaly found");
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findCompanyResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    [Test]
    public void findFormulaXmlNoDataFound() {
        try {
            findFormula(".\\examples\\request\\findFormulaRequest-noDataFound.xml");
            Assert.Fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.IsTrue(e.getAnomalies().size() > 0,"No anomaly found");
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findFormulaResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    [Test]
    public void findIngredientXmlNoDataFound() {
        try {
            findIngredient(".\\examples\\request\\findIngredientRequest-noDataFound.xml");
            Assert.Fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.IsTrue(e.getAnomalies().size() > 0, "No anomaly found");
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findIngredientResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    [Test]
    public void findLegislationXmlNoDataFound() {
        try {
            findLegislation(".\\examples\\request\\findLegislationTextRequest-noDataFound.xml");
            Assert.Fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.IsTrue(e.getAnomalies().size() > 0, "No anomaly found");
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findLegislationTextResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    [Test]
    public void findReimboursementXmlNoDataFound() {
        try {
            findReimboursement(".\\examples\\request\\findReimboursementRequest-noDataFound.xml");
            Assert.Fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.IsTrue(e.getAnomalies().size() > 0, "No anomaly found");
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findReimboursementResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    [Test]
    public void findVmpGroupXmlNoDataFound() {
        try {
            findVmpGroup(".\\examples\\request\\findVmpGroupRequest-noDataFound.xml");
            Assert.Fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.IsTrue(e.getAnomalies().size() > 0, "No anomaly found");
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findVmpGroupResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    [Test]
    public void findVmpXmlNoDataFound() {
        try {
            findVmp(".\\examples\\request\\findVmpRequest-noDataFound.xml");
            Assert.Fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.IsTrue(e.getAnomalies().size() > 0, "No anomaly found");
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findVmpResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    [Test]
    public void findVtmXmlNoDataFound() {
        try {
            findVtm(".\\examples\\request\\findVtmRequest-noDataFound.xml");
            Assert.Fail("This test should send an exception");
        } catch (DicsDataNotFoundException e) {
            Assert.IsTrue(e.getAnomalies().size() > 0, "No anomaly found");
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\findVtmResponse-noDataFound.xml"), ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    [Test]
    public void invalidInput() {
        try {
            findFormula(".\\examples\\request\\InvalidInputRequest.xml");
            Assert.Fail("This test should send an exception");
        } catch (DicsException e) {
            Assert.IsTrue(e.getAnomalies().size() > 0, "No anomaly found");
            XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\InvalidInputResponse.xml"), 
                ConnectorXmlUtils.toString(e.getResponse()));
        }
    }

    private FindAmpResponse findAmpTest(string location) {
        FindAmpRequest request = transformRequest<FindAmpRequest>(location, typeof(FindAmpRequest));

        return DicsSessionServiceFactory.getDicsSession().findAmp(request);
    }

    private FindCommentedClassificationResponse findCommentedClassification(string location) {
        FindCommentedClassificationRequest request = transformRequest<FindCommentedClassificationRequest>(location, typeof(FindCommentedClassificationRequest));

        return DicsSessionServiceFactory.getDicsSession().findCommentedClassification(request);
    }

    private FindCompanyResponse findCompany(string location) {
        FindCompanyRequest request = transformRequest<FindCompanyRequest>(location, typeof(FindCompanyRequest));

        return DicsSessionServiceFactory.getDicsSession().findCompany(request);
    }

    private FindCompoundingFormulaResponse findFormula(string location) {
        FindCompoundingFormulaRequest request = transformRequest<FindCompoundingFormulaRequest>(location, typeof(FindCompoundingFormulaRequest));

        return DicsSessionServiceFactory.getDicsSession().findFormula(request);
    }

    private FindCompoundingIngredientResponse findIngredient(string location) {
        FindCompoundingIngredientRequest request = transformRequest<FindCompoundingIngredientRequest>(location, typeof(FindCompoundingIngredientRequest));

        return DicsSessionServiceFactory.getDicsSession().findIngredient(request);
    }

    private FindLegislationTextResponse findLegislation(string location) {
        FindLegislationTextRequest request = transformRequest<FindLegislationTextRequest>(location, typeof(FindLegislationTextRequest));

        return DicsSessionServiceFactory.getDicsSession().findLegislationText(request);
    }

    private FindReferencesResponse findReferences(string location) {
        FindReferencesRequest request = transformRequest<FindReferencesRequest>(location, typeof(FindReferencesRequest));

        return DicsSessionServiceFactory.getDicsSession().findReferences(request);
    }

    private FindReimbursementResponse findReimboursement(string location) {
        FindReimbursementRequest request = transformRequest<FindReimbursementRequest>(location, typeof(FindReimbursementRequest));

        return DicsSessionServiceFactory.getDicsSession().findReimbursement(request);
    }

    private FindVmpGroupResponse findVmpGroup(string location) {
        FindVmpGroupRequest request = transformRequest<FindVmpGroupRequest>(location, typeof(FindVmpGroupRequest));

        return DicsSessionServiceFactory.getDicsSession().findVmpGroup(request);
    }

    private FindVtmResponse findVtm(string location) {
        FindVtmRequest request = transformRequest<FindVtmRequest>(location, typeof(FindVtmRequest));

        return DicsSessionServiceFactory.getDicsSession().findVtm(request);
    }

    private FindVmpResponse findVmp(string location) {
        FindVmpRequest request = transformRequest<FindVmpRequest>(location, typeof(FindVmpRequest));

        return DicsSessionServiceFactory.getDicsSession().findVmp(request);
    }

    private FindNonMedicinalProductResponse findNonMedicinalProduct(string location) {
        FindNonMedicinalProductRequest request = transformRequest<FindNonMedicinalProductRequest>(location, typeof(FindNonMedicinalProductRequest));

        return DicsSessionServiceFactory.getDicsSession().findNonMedicinalProduct(request);
    }

    private GetListOfActualMedicinalProductPackagesResponse getListOfActualMedicinalProductPackages(string location) {
        GetListOfActualMedicinalProductPackagesRequest request = transformRequest<GetListOfActualMedicinalProductPackagesRequest>(location, typeof(GetListOfActualMedicinalProductPackagesRequest));

        return DicsSessionServiceFactory.getDicsSession().getListOfActualMedicinalProductPackages(request);
    }

    private GetListOfActualMedicinalProductsResponse getListOfActualMedicinalProducts(string location) {
        GetListOfActualMedicinalProductsRequest request = transformRequest<GetListOfActualMedicinalProductsRequest>(location, typeof(GetListOfActualMedicinalProductsRequest));

        return DicsSessionServiceFactory.getDicsSession().getListOfActualMedicinalProducts(request);
    }

    private GetListOfVirtualMedicinalProductsResponse getListOfVirtualMedicinalProducts(string location) {
        GetListOfVirtualMedicinalProductsRequest request = transformRequest<GetListOfVirtualMedicinalProductsRequest>(location, typeof(GetListOfVirtualMedicinalProductsRequest));

        return DicsSessionServiceFactory.getDicsSession().getListOfVirtualMedicinalProducts(request);
    }

    private GetListOfVmpGroupsResponse getListOfVmpGroups(string location) {
        GetListOfVmpGroupsRequest request = transformRequest<GetListOfVmpGroupsRequest>(location, typeof(GetListOfVmpGroupsRequest));

        return DicsSessionServiceFactory.getDicsSession().getListOfVmpGroups(request);
    }

    private T transformRequest<T>(string fileLocation, Class clazz) {
        Map velocityContext = new HashMap();
        velocityContext.put("issueInstant", DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'+02:00'").print(new org.joda.time.DateTime()));
        velocityContext.put("requestId", IdGeneratorFactory.getIdGenerator("uuid").generateId());
        velocityContext.put("currentDate", DateTimeFormat.forPattern("yyyy-MM-dd").print(new org.joda.time.DateTime()));
        velocityContext.put("generatedChars1", RandomStringUtils.randomAlphabetic(10).toLowerCase());
        velocityContext.put("generatedChars2", RandomStringUtils.randomAlphabetic(10).toLowerCase());

        return (T) FileTestUtils.toObject(velocityContext, fileLocation, clazz);
    }
}
}