﻿using System;
using NUnit.Framework;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.businessconnector.consultrnv2.session.support;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.utils;
using be.ehealth.technicalconnector.utils.impl;
using be.fgov.ehealth.rn.personservice.protocol.v1;
using be.fgov.ehealth.rn.registries.commons.v1;
using be.fgov.ehealth.technicalconnector.tests.junit.rule;
using be.fgov.ehealth.technicalconnector.tests.utils;
using java.util;
using java.lang;
using org.w3c.dom;
using javax.xml.bind;

namespace be.ehealth.businessconnector.consultrnv2.session
{
	[TestFixture]
	public class ConsultrnSessionPersonServiceIntegrationTest
	{
		[SetUpAttribute]
	    public static void setupsession() {
	    	SessionInitializer.init(".\\be.ehealth.businessconnector.consultrnv2.test.properties",true, SupportedLanguages.NET.getAbbreviation());
	    	// ConfigFactory.getConfigValidator().setProperty("endpoint.consultrnv2.personservice", "https://services-int.ehealth.fgov.be/rnconsult/PersonService/v1");
	        ConfigFactory.getConfigValidator().setProperty("endpoint.consultrnv2.personservice", "https://preview-intr2.api.ehealth.fgov.be/rnconsult/PersonService/v1");
	    }
		
	    [Test]
	    public void testSearchPersonBySsin() {
	    	RequestTransformer transformer = new RequestTransformer();
	    	SearchPersonBySsinRequest request = transformer.transform<SearchPersonBySsinRequest>(".\\examples\\request\\searchPersonBySsinRequest.xml", typeof(SearchPersonBySsinRequest));
	        SearchPersonBySsinResponse response = ConsultrnSessionServiceFactory.getConsultrnPersonService().searchPersonBySsin(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\searchPersonBySsinResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void testSearchPersonBySsinWithError() {
	        try {
	    		RequestTransformer transformer = new RequestTransformer();
	    		SearchPersonBySsinRequest request = transformer.transform<SearchPersonBySsinRequest>(".\\examples\\request\\searchPersonBySsinRequest-error.xml", typeof(SearchPersonBySsinRequest));
	            ConsultrnSessionServiceFactory.getConsultrnPersonService().searchPersonBySsin(request);
	        } catch (SoaErrorException see) {
	            SearchPersonBySsinResponse response = (SearchPersonBySsinResponse) see.getResponseTypeV2();
	            Assert.AreEqual("The applicationId is malformed", response.getStatus().getStatusMessage());
	        }
	    }
	
	    [Test]
	    public void testSearchPersonPhonetically() {
	    	RequestTransformer transformer = new RequestTransformer();
	    	SearchPersonPhoneticallyRequest request = transformer.transform<SearchPersonPhoneticallyRequest>(".\\examples\\request\\searchPersonPhoneticallyRequest.xml", typeof(SearchPersonPhoneticallyRequest));
	        SearchPersonPhoneticallyResponse response = ConsultrnSessionServiceFactory.getConsultrnPersonService().searchPersonPhonetically(request);
	        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\searchPersonPhoneticallyResponse.xml"), ConnectorXmlUtils.toString(response));
	    }
	
	    [Test]
	    public void testSearchPersonPhoneticallyWithError() {
	        try {
	    		RequestTransformer transformer = new RequestTransformer();
	    		SearchPersonPhoneticallyRequest request = transformer.transform<SearchPersonPhoneticallyRequest>(".\\examples\\request\\searchPersonPhoneticallyRequest-error.xml", typeof(SearchPersonPhoneticallyRequest));
	            ConsultrnSessionServiceFactory.getConsultrnPersonService().searchPersonPhonetically(request);
	        } catch (SoaErrorException see) {
	            SearchPersonPhoneticallyResponse response = (SearchPersonPhoneticallyResponse) see.getResponseTypeV2();
	            Assert.AreEqual("Algorithm for given name doesn’t exists", response.getStatus().getStatusMessage());
	        }
	    }
	    
	    [Test]
        public void testSearchPersonPhoneticallyWithValidationError() {
            try {
                RequestTransformer transformer = new RequestTransformer();
                SearchPersonPhoneticallyRequest request = transformer.transform<SearchPersonPhoneticallyRequest>(".\\examples\\request\\searchPersonPhoneticallyRequest-validationError.xml", typeof(SearchPersonPhoneticallyRequest));
                ConsultrnSessionServiceFactory.getConsultrnPersonService().searchPersonPhonetically(request);
            } catch (SoaErrorException see) {
                SearchPersonPhoneticallyResponse response = (SearchPersonPhoneticallyResponse) see.getResponseTypeV2();
                Assert.AreEqual("Business validation error", response.getStatus().getStatusMessage());

                org.w3c.dom.Element elt = (org.w3c.dom.Element) response.getStatus().getStatusDetail().getAnies().get(0);
                JAXBContext context = JaxbContextFactory.getJaxbContextForClass(typeof(ValidationErrors));
                Unmarshaller unmarshaller = context.createUnmarshaller();
                ValidationErrors errors = (ValidationErrors) unmarshaller.unmarshal(elt);

                DetailedStatusType validationError = (DetailedStatusType) errors.getValidationErrors().get(0);
                Assert.AreEqual("900021", validationError.getCode());
                Assert.AreEqual("Invalid country code", validationError.getDescription());
            }
        }
	}
}
