package be.fgov.ehealth.technicalconnector.tests.server.callback;

import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import org.apache.commons.lang.StringUtils;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

import java.util.ArrayDeque;
import java.util.Queue;

public class ContentExpectationCallback extends AbstractExpectationCallback {

    private Queue<String> content = new ArrayDeque<String>();

    @Override
    public HttpResponse handle(HttpRequest httpRequest) {
        try {
            String body = content.poll();
            if (!StringUtils.startsWith(body, "<")) {
                body = ConnectorIOUtils.getResourceAsString(body);
            }
            return HttpResponse.response()
                    .withStatusCode(200)
                    .withHeader("Content-Type","text/xml")
                    .withBody(body);
        } catch (Exception e) {
            return internalError(e.getMessage(), e);
        }
    }


    public void add(String location){
        content.add(location);
    }
}
