package be.ehealth.businessconnector.consultrnv2.session;

import be.ehealth.businessconnector.consultrnv2.session.support.RequestTransformer;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.exception.SoaErrorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.fgov.ehealth.rn.cbsspersonservice.protocol.v1.RegisterPersonRequest;
import be.fgov.ehealth.rn.cbsspersonservice.protocol.v1.RegisterPersonResponse;
import be.fgov.ehealth.rn.registries.commons.v1.DetailedStatusType;
import be.fgov.ehealth.rn.registries.commons.v1.ValidationErrors;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.w3c.dom.Element;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class ConsultrnSessionCBSSPersonServiceIntegrationTest {

    private static final RequestTransformer TRANSFORMER = new RequestTransformer();

    @ClassRule
    public static SessionRule sessionRule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.consultrnv2.test.properties").build();

    @BeforeClass
    public static void setup() {
//        ConfigFactory.getConfigValidator().setProperty("endpoint.consultrnv2.cbsspersonservice", "https://services-int.ehealth.fgov.be/rnconsult/CbssPersonService/v1");
        ConfigFactory.getConfigValidator().setProperty("endpoint.consultrnv2.cbsspersonservice", "https://preview-intr2.api.ehealth.fgov.be/rnconsult/CbssPersonService/v1");
    }

    @Test
    public void testRegisterPerson() throws Exception {
        RegisterPersonRequest request = TRANSFORMER.transform("/examples/request/registerPersonRequest.xml", RegisterPersonRequest.class);
        RegisterPersonResponse response = ConsultrnSessionServiceFactory.getConsultrnCBSSPersonService().registerPerson(request);
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/response/registerPersonResponse.xml"), ConnectorXmlUtils.toString(response));
    }

    @Test
    public void testRegisterPersonWithError() throws Exception {
        try {
            RegisterPersonRequest request = TRANSFORMER.transform("/examples/request/registerPersonRequest-error.xml", RegisterPersonRequest.class);
            ConsultrnSessionServiceFactory.getConsultrnCBSSPersonService().registerPerson(request);
        } catch (SoaErrorException see) {
            RegisterPersonResponse response = (RegisterPersonResponse) see.getResponseTypeV2();
            Assert.assertEquals("The request contains invalid data. Please check your message content.", response.getStatus().getStatusMessage());

            Element elt = (Element) response.getStatus().getStatusDetail().getAnies().get(0);
            JAXBContext context = JaxbContextFactory.getJaxbContextForClass(ValidationErrors.class);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            ValidationErrors errors = (ValidationErrors) unmarshaller.unmarshal(elt);

            DetailedStatusType validationError = errors.getValidationErrors().get(0);
            Assert.assertEquals("400304", validationError.getCode());
            Assert.assertEquals("CountryCode 150 present without cityCode specified", validationError.getDescription());
        }
    }

}
