using be.fgov.ehealth.technicalconnector.tests.utils;
#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

namespace be.fgov.ehealth.technicalconnector.tests.utils.net
{
    using System;

    using be.ehealth.technicalconnector.exception;
    using be.ehealth.technicalconnector.utils;
	using be.fgov.ehealth.technicalconnector.tests.utils.net;

    using java.io;
    using java.lang;
    using java.util;

    using org.apache.commons.lang;

    /// <summary>
    /// Description of TestPropertiesLoader.
    /// </summary>
    public class TestPropertiesNetLoader
    {
        #region Fields

        private static Map cache = new HashMap();
        private static string DEFAULT_PROP_NAME = ".\\be.ehealth.technicalconnector.test.properties";

        #endregion Fields

        #region Constructors

        private TestPropertiesNetLoader()
        {
            // Utility class no need to have a public constructor
        }

        #endregion Constructors

        #region Methods

        /**
         * @return the properties from default location
         * @throws TechnicalConnectorException
         */
        public static Properties getProperties()
        {
        	return getProperties(DEFAULT_PROP_NAME,".net");
        }

        /**
         * @param location
         * @return the properties from given location
         * @throws TechnicalConnectorException
         */
        public static Properties getProperties(string location,string devLang)
        {
            if (!cache.containsKey(location)) {
                Properties props = new Properties();
                try {
                    InputStream inputs = ConnectorIOUtils.getResourceAsStream(location);
                    if (inputs == null) {
                        TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.ERROR_CONFIG;
                        throw new TechnicalConnectorException(errorValue, "Could not load test properties file [" + location + "]");
                    }
                    props.load(ConnectorIOUtils.getResourceAsStream(location));
                } catch (IOException e) {
                    TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.ERROR_CONFIG;
                    throw new TechnicalConnectorException(errorValue, "Could not load test properties file",e);
                }
            cache.put(location, processProps(props,devLang));
            }
            return (Properties) cache.get(location);
        }

        public static Properties processProps(Properties props,string devLang)
        {
            Properties solvedProps = new Properties();
            Set keySet = props.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                string key = (string)it.next();
                string value = getValue(props, key.ToString(), null);
                if (".net".Equals(devLang)) {
	                if (value.StartsWith("/")) {
	                    value = StringUtils.replaceOnce(value, "/", ".\\\\");
	                }
	            }
                if (value != null) {
                    solvedProps.put(key, value);
                } else {
                    throw new IllegalArgumentException("TestPropertiesLoader : no value defined for property " + key + " ,fill this property, or remove it if not needed ");
                }
            }
            return solvedProps;
        }

        private static string getValue(Properties props, string key, string defaultValue)
        {
            string keyValue = key;
            if (props.getProperty(key) != null && props.getProperty(key).StartsWith("${")) {
                keyValue = StringUtils.substringBetween(props.getProperty(key), "${", "}");
                return getValue(props, keyValue, defaultValue);
            }
            

            return props.getProperty(key, defaultValue);
        }

        #endregion Methods
    }
}