﻿/*
 * Created by SharpDevelop.
 * User: EH076
 * Date: 28/10/2016
 * Time: 10:04
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;

using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.utils;
using be.ehealth.technicalconnector.config;

using java.io;
using java.lang;
using java.util;

using org.apache.commons.lang;

namespace be.fgov.ehealth.technicalconnector.jca.util
{



	/// <summary>
	/// Description of JcaTestPropertiesLoader.
	/// </summary>
	public class JcaTestPropertiesLoader
	{

		#region Fields

		private static Map cache = new HashMap();
		private static string DEFAULT_PROP_NAME = ".\\be.ehealth.technicalconnector.test.properties";

		#endregion Fields

		public JcaTestPropertiesLoader()
		{
		}

		#region Methods

		/**
		 * @return the properties from default location
		 * @throws TechnicalConnectorException
		 */
		public static Properties getProperties()
		{
			return getProperties(DEFAULT_PROP_NAME,".net");
		}

		/**
		 * @param location
		 * @return the properties from given location
		 * @throws TechnicalConnectorException
		 */
		public static Properties getProperties(string location,string devLang)
		{
			if (!cache.containsKey(location)) {
				Properties props = new Properties();
				try {
					InputStream inputs = ConnectorIOUtils.getResourceAsStream(location);
					if (inputs == null) {
						TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.ERROR_CONFIG;
						throw new TechnicalConnectorException(errorValue, "Could not load test properties file [" + location + "]");
					}
					props.load(ConnectorIOUtils.getResourceAsStream(location));
				} catch (IOException e) {
					TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.ERROR_CONFIG;
					throw new TechnicalConnectorException(errorValue, "Could not load test properties file",e);
				}
				
				alterConfig(props);			
								
				cache.put(location, processProps(props,devLang));
			}
			return (Properties) cache.get(location);
		}

		public static Properties processProps(Properties props,string devLang)
		{
			Properties solvedProps = new Properties();
			Set keySet = props.keySet();
			Iterator it = keySet.iterator();
			while (it.hasNext()) {
				string key = (string)it.next();
				string value = getValue(props, key.ToString(), null);
				if (".net".Equals(devLang)) {
					if (value.StartsWith("/")) {
						value = StringUtils.replaceOnce(value, "/", ".\\\\");
					}
				}
				if (value != null) {
					solvedProps.put(key, value);
				} else {
					throw new IllegalArgumentException("TestPropertiesLoader : no value defined for property " + key + " ,fill this property, or remove it if not needed ");
				}
			}
			return solvedProps;
		}
		
		private static void alterConfig(Properties props){
			ConfigValidator config = ConfigFactory.getConfigValidator();
			Iterator keySetIt = props.keySet().iterator();
			while (keySetIt.hasNext()) {
				object keyObj= keySetIt.next();
				string key = keyObj.ToString();
				if (!key.StartsWith("test.")) {
					config.setProperty(key, props.getProperty(key));
				}
			}
		}

		private static string getValue(Properties props, string key, string defaultValue)
		{
			string keyValue = key;
			if (props.getProperty(key) != null && props.getProperty(key).StartsWith("${")) {
				keyValue = StringUtils.substringBetween(props.getProperty(key), "${", "}");
				return getValue(props, keyValue, defaultValue);
			}


			return props.getProperty(key, defaultValue);
		}

		#endregion Methods

	}
}
