﻿/*
 * Copyright (c) eHealth
 */
using System;
using NUnit.Framework;

using System;

using be.fgov.ehealth.errors.core.v1;
using be.fgov.ehealth.technicalconnector.tests.utils;
using ikvm.extensions;
using NUnit.Framework;
using java.math;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.utils;
using be.ehealth.technicalconnector.enumeration;
using be.fgov.ehealth.technicalconnector.tests.junit.rule;
using be.ehealth.businessconnector.genericasync.domain;
using be.ehealth.businessconnector.medadmin.domain;
using be.cin.mycarenet._1_0.carenet.types;
using be.cin.encrypted;
using be.ehealth.businessconnector.medadmin.session;
using NUnit.Framework;
using org.slf4j;


namespace be.ehealth.businessconnector.medadmin.session
{
	 
	[TestFixture]
	public class MedAdminGetAsyncIntegrationTest
	{
		private static Logger LOG = LoggerFactory.getLogger(typeof(MedAdminGetAsyncIntegrationTest));
		 
        [SetUp]
        public static void setup() {
           SessionInitializer.init(".\\be.ehealth.businessconnector.medadmin.test.properties",true,SupportedLanguages.NET.getAbbreviation());
        }
        
        [Test]
        public void getM4AXmlMessage() {
            M4AXmlProcessedGetResponse response = MedadminSessionServiceFactory.getMedadminService()
                    .getM4AXml(GetRequest.newBuilder().withDefaults().build());
                      
            M4AXmlProcessedMsgResponse msgResponse = (M4AXmlProcessedMsgResponse) response.getMsgResponses().get(0);
            Assert.IsTrue(msgResponse.getSingleNurseContractualCareResponses().size() > 0
                    || msgResponse.getSinglePalliativeCareResponses().size() > 0
                    || msgResponse.getSingleSpecificTechnicalCareResponses().size() > 0
                    || msgResponse.getSingleNurseContractualCareUpdates().size() > 0);   
            
            MedadminSessionServiceFactory.getMedadminService().confirmAllMessages(response);
        }
        
        [Test]
        public void getM4AFlatMessage() {
            ProcessedGetResponse response = MedadminSessionServiceFactory.getMedadminService()
                    .getM4AFlat(GetRequest.newBuilder().withMaxMessages(new java.lang.Integer(1)).withMaxTAcks(new java.lang.Integer(0)).build());
            
            byte[] businessContent = (byte[]) ((ProcessedMsgResponse) response.getMsgResponses().get(0)).getBusinessResponse();
            LOG.info("Content of M4A_FLAT response: {}", ConnectorIOUtils.toString(businessContent, Charset.UTF_8).toString());
            Assert.IsNotNull(businessContent);
                    
            assertSignature((ProcessedMsgResponse) response.getMsgResponses().get(0));
        }
    
        [Test]
        public void getM4ACnfXml() {
            M4ACnfXmlProcessedGetResponse response = MedadminSessionServiceFactory.getMedadminService()
                    .getM4ACnfXml(GetRequest.newBuilder().withDefaults().build());
            
            M4ACnfXmlProcessedMsgResponse msgResponse = (M4ACnfXmlProcessedMsgResponse) response.getMsgResponses().get(0);
            Assert.IsTrue(msgResponse.getSingleNurseContractualCareRequests().size() > 0
                    || msgResponse.getSinglePalliativeCareRequests().size() > 0
                    || msgResponse.getSingleSpecificTechnicalCareRequests().size() > 0);
            
            MedadminSessionServiceFactory.getMedadminService().confirmAllMessages(response);
        }
    
        [Test]
        public void getM4ACnfFlat() {
            ProcessedGetResponse response = MedadminSessionServiceFactory.getMedadminService()
                    .getM4ACnfFlat(GetRequest.newBuilder().withDefaults().build());
            
            byte[] businessContent = (byte[]) ((ProcessedMsgResponse) response.getMsgResponses().get(0)).getBusinessResponse();
            LOG.info("Content of M4A_CNF_FLAT response: {}", ConnectorIOUtils.toString(businessContent, Charset.UTF_8));
            Assert.IsNotNull(businessContent);  
                     
            MedadminSessionServiceFactory.getMedadminService().confirmAllMessages(response);
        }
    
    
        private void assertSignature(ProcessedMsgResponse processedMsgResponse) {
            Assert.AreEqual(0, processedMsgResponse.getSignatureVerificationResult().getErrors().size(), "SignatureVerificationResult should contain no error");
            Assert.IsNotNull(processedMsgResponse.getMsgResponse().getXadesT(), "Missing xades");
            XmlAsserter.assertSimilar(ConnectorXmlUtils.toObject(processedMsgResponse.getSignedData(), typeof(EncryptedKnownContent)), processedMsgResponse.getRawDecryptedBlob());
        }
	}
}
