﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.fgov.ehealth.technicalconnector.tests.session;
using java.lang;
using java.util;
using be.ehealth.technicalconnector.idgenerator;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.hubservices.core.v3;
using NUnit.Framework;
using org.joda.time;
using org.joda.time.format;
using be.ehealth.businessconnector.hubv3.builders;
using be.ehealth.businessconnector.hubv3.service;
using be.ehealth.businessconnector.hubv3.session;
using be.ehealth.businessconnector.hubv3.helpers;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.standards.kmehr.cd.v1;
using be.fgov.ehealth.standards.kmehr.id.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.config.impl;
using be.ehealth.technicalconnector.session;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.ehealth.business.intrahubcommons.exception;
using be.ehealth.business.kmehrcommons.helper;
using be.ehealth.businessconnector.testcommons;
using org.apache.commons.lang;
using be.ehealth.business.common.domain;

namespace be.ehealth.businessconnector.hubv3.helpers
{
	public class HubTestHelper
    {
	   private static Configuration config = ConfigFactory.getConfigValidator();
       
           private string testFilesLocation;
           private Patient testPatient;
           
           public HubTestHelper(string testFilesLocation, Patient testPatient) {
               this.testPatient = testPatient;  
               this.testFilesLocation = testFilesLocation;
           }
       
           public string expectedResponse(string scenarioName) {
               Map velocityContext = new HashMap();
               velocityContext.put("requestDate", DateTimeFormat.forPattern("dd/MM/yyyy").print(new org.joda.time.DateTime()));
               return TemplateEngineUtils.generate(velocityContext, ".\\expected\\" + testFilesLocation + "\\" + scenarioName + " - response.xml");
           }
       
       
           /**
            * Create an IDPATIENT for Niss
            */
           private IDPATIENT createIdPatientInss() {
               IDPATIENT idPatient = new IDPATIENT();
               idPatient.setS(IDPATIENTschemes.INSS);
               idPatient.setSV("1.0");
               idPatient.setValue(testPatient.getInss());
               return idPatient;
           }
       
           /**
            * Create an IDPATIENT for Niss
            */
           private IDPATIENT createIdPatientCardno() {
               IDPATIENT idPatient = new IDPATIENT();
               idPatient.setS(IDPATIENTschemes.EID_CARDNO);
               idPatient.setSV("1.0");
               idPatient.setValue(testPatient.getEidCardNumber());
               return idPatient;
           }
       
           /**
            * Create an IDHCPARTY for Niss
            */
           private IDHCPARTY createIdHcPartyNiss(string value) {
               IDHCPARTY idHcparty = new IDHCPARTY();
               idHcparty.setS(IDHCPARTYschemes.INSS);
               idHcparty.setSV("1.0");
               idHcparty.setValue(value);
               return idHcparty;
           }
       
           /**
            * Create an IDHCPARTY for Nihii
            */
           public IDHCPARTY createIdHcPartyNihii() {
               IDHCPARTY idHcparty = new IDHCPARTY();
               idHcparty.setS(IDHCPARTYschemes.ID_HCPARTY);
               idHcparty.setSV("1.0");
               idHcparty.setValue(SessionUtil.getNihii11());
               return idHcparty;
           }
       
           /**
            * Create an IDKMEHR with the specified value
            */
           public IDKMEHR createMessageId(string value) {
               IDKMEHR id = new IDKMEHR();
               id.setS(IDKMEHRschemes.ID_KMEHR);
               id.setSV("1.0");
               id.setValue(value);
               return id;
           }
       
           /**
            * Create a HcPartyId with the informations of the professional
            */
           public HCPartyIdType createHcPartyIdProfessional() {
               HCPartyIdType hcParty = new HCPartyIdType();
               IDHCPARTY idHcparty = createIdHcPartyNihii();
               hcParty.getIds().add(idHcparty);
               idHcparty = createIdHcPartyNihii();
               hcParty.getIds().add(idHcparty);
               return hcParty;
           }
       
           /**
            * Create the professional HcParty
            */
           private be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType createHcPartyProfessional() {
               be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType hcParty = new be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType();
               hcParty.setFamilyname(HubConfigCommon.PROF_LASTNAME);
               hcParty.setFirstname(HubConfigCommon.PROF_FIRSTNAME);
               CDHCPARTY cdHcParty = createCdHcPartyProfession();
               hcParty.getCds().add(cdHcParty);
               IDHCPARTY idHcparty = createIdHcPartyNiss(HubConfigCommon.PROF_NISS);
               hcParty.getIds().add(idHcparty);
               return hcParty;
           }
       
           /**
            * Create a PatientIdType Used by createConsentType
            */
           public PatientIdType createPatientIdType() {
               PatientIdType patient = new PatientIdType();
               IDPATIENT idPatient = createIdPatientInss();
               patient.getIds().add(idPatient);
               if (this.testPatient.getEidCardNumber() != null) {
                   IDPATIENT idPatientCardNo = createIdPatientCardno();
                   patient.getIds().add(idPatientCardNo);
               }    
               return patient;
           }
       
           /**
            * Create a cd with the profession in it Used by createHcPartyProfessional
            */
           public CDHCPARTY createCdHcPartyProfession() {
               CDHCPARTY cdHcParty = new CDHCPARTY();
               cdHcParty.setS(CDHCPARTYschemes.CD_HCPARTY);
               cdHcParty.setSV("1.0");
               cdHcParty.setValue(HubConfigCommon.PROF_PROFESSION);
               return cdHcParty;
           }
       
           /**
            * Create the header of the transaction
            */
           public HeaderType createHeader(string standardDate) {
               HeaderType header = new HeaderType();
       
               StandardType standard = new StandardType();
               CDSTANDARD cd = new CDSTANDARD();
               cd.setSV("1.4");
               cd.setValue(standardDate);
               cd.setS("CD-STANDARD");
               standard.setCd(cd);
       
               header.setStandard(standard);
               header.getIds().add(createMessageId(SessionUtil.getNihii11() + "." + IdGeneratorFactory.getIdGenerator().generateId()));
               org.joda.time.DateTime now = new org.joda.time.DateTime();
               header.setDate(now);
               header.setTime(now);
               header.getRecipients().add(createHubRecipient());
               header.setSender(createSender());
               return header;
           }
       
           /**
            * Create the author of the operation
            */
           private SenderType createSender() {
               be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType hcParty = new be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType();
       
               IDHCPARTY doctorNISS = new IDHCPARTY();
               IDHCPARTY doctorNIHII = new IDHCPARTY();
               CDHCPARTY hcPartytype = new CDHCPARTY();
       
               doctorNIHII.setS(IDHCPARTYschemes.ID_HCPARTY);
               doctorNIHII.setSV("1.0");
               doctorNIHII.setValue(SessionUtil.getNihii());
       
               doctorNISS.setS(IDHCPARTYschemes.INSS);
               doctorNISS.setSV("1.0");
               doctorNISS.setValue(HubConfigCommon.PROF_NISS);
       
               hcPartytype.setS(CDHCPARTYschemes.CD_HCPARTY);
               hcPartytype.setSV("1.0");
               hcPartytype.setValue(HubConfigCommon.PROF_PROFESSION);
       
               hcParty.getIds().add(doctorNIHII);
               hcParty.getIds().add(doctorNISS);
               hcParty.getCds().add(hcPartytype);
       
               hcParty.setFamilyname(HubConfigCommon.PROF_LASTNAME);
               hcParty.setFirstname(HubConfigCommon.PROF_FIRSTNAME);
       
               SenderType sender = new SenderType();
               sender.getHcparties().add(hcParty);
       
               return sender;
           }
       
           /**
            * Create the author of the operation
            */
           public AuthorType createAuthor() {
               AuthorType author = new AuthorType();
               be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType hcParty = createHcPartyProfessional();
               author.getHcparties().add(hcParty);
               return author;
           }
       
           /**
            * Create the Hub of the operation
            */
           private RecipientType createHubRecipient() {
               be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType hub = new be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType();
       
               IDHCPARTY id = new IDHCPARTY();
               id.setValue(config.getProperty(ServiceFactory.PROP_HUBID));
               id.setS(IDHCPARTYschemes.ID_HCPARTY);
               id.setSV("1.0");
               hub.getIds().add(id);
       
               CDHCPARTY cd = new CDHCPARTY();
               cd.setValue("hub");
               cd.setSV("1.0");
               cd.setS(CDHCPARTYschemes.CD_HCPARTY);
               hub.getCds().add(cd);
       
               hub.setName(HubConfigCommon.HUB_NAME);
               RecipientType recipient = new RecipientType();
               recipient.getHcparties().add(hub);
               return recipient;
           }
          
       
           /**
            * Create a consentType used for consent operations
            */
           public ConsentType createConsentType() {
               ConsentType consent = new ConsentType();
       
               CDCONSENT cdConsent = new CDCONSENT();
               cdConsent.setS(CDCONSENTschemes.CD_CONSENTTYPE);
               cdConsent.setSV("1.0");
               cdConsent.setValue(CDCONSENTvalues.RETROSPECTIVE);
               consent.getCds().add(cdConsent);
       
               consent.setAuthor(createAuthor());
               consent.setPatient(createPatientIdType());
               consent.setSigndate(new org.joda.time.DateTime());
       
               return consent;
           }
       
           /**
            * Create a TherapeuticLinkType used for ther link operations
            */
           public TherapeuticLinkType createTherapeuticLinkType() {
               TherapeuticLinkType therapeuticLink = new TherapeuticLinkType();
       
               CDTHERAPEUTICLINK cdTherLink = new CDTHERAPEUTICLINK();
               cdTherLink.setS(CDTHERAPEUTICLINKschemes.CD_THERAPEUTICLINKTYPE);
               cdTherLink.setSV("1.0");
               cdTherLink.setValue("gpconsultation");
               therapeuticLink.setCd(cdTherLink);
       
               therapeuticLink.setHcparty(createHcPartyIdProfessional());
               therapeuticLink.setPatient(createPatientIdType());
               therapeuticLink.setStartdate(new org.joda.time.DateTime());
               return therapeuticLink;
           }
       
           /**
            * Create the transaction id with the specified value
            */
           public IDKMEHR createIdKmehr(string sl, string sv, string value,IDKMEHRschemes s) {
               IDKMEHR id = new IDKMEHR();
               id.setS(s);
               id.setSL(sl);
               id.setSV(sv);
               id.setValue(value);
               return id;
           }
       
           /**
            * Create the testPatient needed for some transaction
            */
           public PersonType createPatientForTransaction() {
               PersonType patient = new PersonType();
       
               IDPATIENT kmehrPatientId = new IDPATIENT();
               kmehrPatientId.setS(IDPATIENTschemes.INSS);
               kmehrPatientId.setSV("1.0");
               kmehrPatientId.setValue(testPatient.getInss());
               patient.getIds().add(kmehrPatientId);
       
               patient.getFirstnames().add(testPatient.getFirstName());
               patient.setFamilyname(testPatient.getLastName());
       
               SexType sexType = new SexType();
               CDSEX cdSex = new CDSEX();
               cdSex.setValue(CDSEXvalues.MALE);
               cdSex.setS("CD-SEX");
               cdSex.setSV("1.0");
               sexType.setCd(cdSex);
               patient.setSex(sexType);
               return patient;
           }
       
           /**
            * Create the testPatient needed for the putPatient operation
            */
           public PersonType createPatient() {
               PersonType person = new PersonType();
               person.getFirstnames().add(testPatient.getFirstName());
               person.setFamilyname(testPatient.getLastName());
               person.setRecorddatetime(new org.joda.time.DateTime());
               person.setUsuallanguage("fr");
       
               DateType dateType = new DateType();
               dateType.setDate(new org.joda.time.DateTime().withDayOfMonth(12).withMonthOfYear(12).withYear(1991));
               person.setBirthdate(dateType);
       
               Nationality nationality = new Nationality();
               CDCOUNTRY cdCountry = new CDCOUNTRY();
               cdCountry.setS(CDCOUNTRYschemes.CD_FED_COUNTRY);
               cdCountry.setSV("1.0");
               cdCountry.setValue("BE");
               nationality.setCd(cdCountry);
               person.setNationality(nationality);
       
               SexType sex = new SexType();
               CDSEX cdSex = new CDSEX();
               cdSex.setS("CD-SEX");
               cdSex.setSV("1.0");
               cdSex.setValue(CDSEXvalues.MALE);
               sex.setCd(cdSex);
               person.setSex(sex);
       
               person.getIds().add(createIdPatientInss());
               return person;
           }
       
           public HCPartyAdaptedType createHcPartyAdaptedType() {
               HCPartyAdaptedType hcParty = new HCPartyAdaptedType();
               hcParty.setFamilyname(HubConfigCommon.PROF_LASTNAME);
               hcParty.setFirstname(HubConfigCommon.PROF_FIRSTNAME);
               CDHCPARTY cdHcParty = createCdHcPartyProfession();
               hcParty.getCds().add(cdHcParty);
               IDHCPARTY idHcpartyNihii = createIdHcPartyNihii();
               hcParty.getIds().add(idHcpartyNihii);
               hcParty.setRecorddatetime(new org.joda.time.DateTime());
               hcParty.getAddresses().add(createAddress());
               hcParty.getTelecoms().add(createTelecom());
               IDHCPARTY idHcpartyNiss = createIdHcPartyNiss(HubConfigCommon.PROF_NISS);
               hcParty.getIds().add(idHcpartyNiss);
               return hcParty;
           }
       
           /**
            * Create a selectGetPatientConsentType used for consent operations
            */
           public SelectGetPatientConsentType createSelectGetPatientConsentType() {
               SelectGetPatientConsentType patientConsent = new SelectGetPatientConsentType();
       
               Consent selectConsent = new Consent();
               CDCONSENT cdConsent = new CDCONSENT();
               cdConsent.setS(CDCONSENTschemes.CD_CONSENTTYPE);
               cdConsent.setSV("1.0");
               cdConsent.setValue(CDCONSENTvalues.RETROSPECTIVE);
               selectConsent.getCds().add(cdConsent);
               patientConsent.setConsent(selectConsent);
       
               patientConsent.setPatient(createPatientIdType());
               return patientConsent;
           }
       
           /**
            * Create a SelectGetHCPartyPatientConsentType used for ther link operations
            */
           public SelectGetHCPartyPatientConsentType createSelectGetHCPartyPatientConsentType() {
               SelectGetHCPartyPatientConsentType selectConsent = new SelectGetHCPartyPatientConsentType();
       
               CDTHERAPEUTICLINK cdTherLink = new CDTHERAPEUTICLINK();
               cdTherLink.setS(CDTHERAPEUTICLINKschemes.CD_THERAPEUTICLINKTYPE);
               cdTherLink.setSV("1.0");
               cdTherLink.setValue("gpconsultation");
               selectConsent.getCds().add(cdTherLink);
       
               selectConsent.getPatientsAndHcparties().add(createPatientIdType());
               selectConsent.getPatientsAndHcparties().add(createHcPartyIdProfessional());
               selectConsent.setBegindate(new org.joda.time.DateTime());
               selectConsent.setEnddate(new org.joda.time.DateTime());
       
               return selectConsent;
           }
       
           public Kmehrmessage createPutTransactionMessage() {
                   Kmehrmessage kmehrmessage = new Kmehrmessage();
                   setHeaderTo(kmehrmessage);
                   addTransactionTo(addFolderTo(kmehrmessage));
           
               return kmehrmessage;
           }
       
           public Kmehrmessage createPutTransactionMessageWithLocalId() {
               Kmehrmessage kmehrmessage = new Kmehrmessage();
               setHeaderTo(kmehrmessage);
               addLocalIdTo(addTransactionTo(addFolderTo(kmehrmessage)));
       
               return kmehrmessage;
           }
       
           private void addLocalIdTo(TransactionType addedTransaction) {
               addedTransaction.getIds().add(createIdKmehr("EHBASICSOFT", "1.0", IdGeneratorFactory.getIdGenerator(
                       IdGeneratorFactory.UUID).generateId(), IDKMEHRschemes.LOCAL));
           }
       
           private TransactionType addTransactionTo(be.fgov.ehealth.standards.kmehr.schema.v1.FolderType folder) {
               TransactionType transaction = createTransactionType(
                       IdGeneratorFactory.getIdGenerator(
                               IdGeneratorFactory.UUID).generateId(),
                       "<transaction xmlns='http://www.ehealth.fgov.be/standards/kmehr/schema/v1'><cd S='CD-TRANSACTION' SV='1.4'>sumehr</cd><date>2013-07-17</date><time>10:01:51+01:00</time><iscomplete>true</iscomplete><isvalidated>true</isvalidated><item><id S='ID-KMEHR' SV='1.0'>1</id><cd S='CD-ITEM' SV='1.4'>risk</cd><content><text L='fr'>travail sur écran</text></content><beginmoment><date>2013-06-21</date><time>14:51:24+01:00</time></beginmoment><recorddatetime>2013-06-21T14:53:28+02:00</recorddatetime></item><item><id S='ID-KMEHR' SV='1.0'>2</id><cd S='CD-ITEM' SV='1.4'>adr</cd><content><text L='fr'>Ticlopidine</text></content><beginmoment><date>2013-06-21</date><time>14:51:24+01:00</time></beginmoment><recorddatetime>2013-06-21T14:52:34+02:00</recorddatetime></item><item><id S='ID-KMEHR' SV='1.0'>3</id><cd S='CD-ITEM' SV='1.4'>medication</cd><content><cd S='CD-ATC' SV='1.0'>B01AC05</cd></content><content><text L='fr'>Ticlid (c) 250mg - 30 compr. enrobé(s)</text></content><content><medicinalproduct><intendedcd S='CD-DRUG-CNK' SV='2.0'>0857995</intendedcd><intendedname>Ticlid (c) 250mg - 30 compr. enrobé(s)</intendedname></medicinalproduct></content><beginmoment><date>2013-06-21</date></beginmoment><lifecycle><cd S='CD-LIFECYCLE' SV='1.3'>prescribed</cd></lifecycle><isrelevant>true</isrelevant><temporality><cd S='CD-TEMPORALITY' SV='1.0'>chronic</cd></temporality><quantity><decimal>1</decimal><unit><cd S='CD-UNIT' SV='1.3'>pkg</cd></unit></quantity><instructionforpatient L='fr'>1 compr. enrobé(s) 1 x / jour</instructionforpatient><recorddatetime>2013-06-21T14:51:24+02:00</recorddatetime></item><item><id S='ID-KMEHR' SV='1.0'>4</id><cd S='CD-ITEM' SV='1.4'>medication</cd><content><cd S='CD-ATC' SV='1.0'>C10AA07</cd></content><content><text L='fr'>rosuvastatine 40 mg - 98 compr. pelliculé(s)</text></content><content><medicinalproduct><intendedcd S='CD-DRUG-CNK' SV='2.0'>2055176</intendedcd><intendedname>rosuvastatine 40 mg - 98 compr. pelliculé(s)</intendedname></medicinalproduct></content><beginmoment><date>2013-06-21</date></beginmoment><endmoment><date>2013-09-27</date></endmoment><lifecycle><cd S='CD-LIFECYCLE' SV='1.3'>prescribed</cd></lifecycle><isrelevant>true</isrelevant><temporality><cd S='CD-TEMPORALITY' SV='1.0'>acute</cd></temporality><quantity><decimal>1</decimal><unit><cd S='CD-UNIT' SV='1.3'>pkg</cd></unit></quantity><instructionforpatient L='fr'>1 compr. 1 x / jour</instructionforpatient><recorddatetime>2013-06-21T14:51:24+02:00</recorddatetime></item><item><id S='ID-KMEHR' SV='1.0'>5</id><cd S='CD-ITEM' SV='1.4'>vaccine</cd><content><cd S='CD-VACCINEINDICATION' SV='1.0'>diphteria</cd><cd S='CD-VACCINEINDICATION' SV='1.0'>tetanus</cd><cd S='CD-ATC' SV='1.0'>J07AM51</cd></content><content><medicinalproduct><intendedcd S='CD-DRUG-CNK' SV='2.0'>1077593</intendedcd><intendedname>Tedivax pro adulto (c)</intendedname></medicinalproduct></content><beginmoment><date>2013-05-28</date></beginmoment><lifecycle><cd S='CD-LIFECYCLE' SV='1.3'>administrated</cd></lifecycle><recorddatetime>2013-06-21T14:53:34+02:00</recorddatetime></item><item><id S='ID-KMEHR' SV='1.0'>6</id><cd S='CD-ITEM' SV='1.4'>vaccine</cd><content><cd S='CD-VACCINEINDICATION' SV='1.0'>diphteria</cd><cd S='CD-VACCINEINDICATION' SV='1.0'>tetanus</cd><cd S='CD-VACCINEINDICATION' SV='1.0'>pertussis</cd><cd S='CD-VACCINEINDICATION' SV='1.0'>poliomyelitis</cd><cd S='CD-ATC' SV='1.0'>J07CA02</cd></content><content><medicinalproduct><intendedcd S='CD-DRUG-CNK' SV='2.0'>2374429</intendedcd><intendedname>Boostrix Polio (c)</intendedname></medicinalproduct></content><beginmoment><date>2013-05-28</date></beginmoment><lifecycle><cd S='CD-LIFECYCLE' SV='1.3'>administrated</cd></lifecycle><recorddatetime>2013-06-21T14:53:34+02:00</recorddatetime></item></transaction>");
               folder.getTransactions().add(transaction);
               
               return transaction;
           }
       
           private be.fgov.ehealth.standards.kmehr.schema.v1.FolderType addFolderTo(Kmehrmessage kmehrmessage) {
               be.fgov.ehealth.standards.kmehr.schema.v1.FolderType folder = new be.fgov.ehealth.standards.kmehr.schema.v1.FolderType();
               folder.getIds().add(createMessageId(HubConfigCommon.MESSAGE_ID));
               folder.setPatient(createPatientForTransaction());
               kmehrmessage.getFolders().add(folder);
               return folder;
           }
       
           private void setHeaderTo(Kmehrmessage kmehrmessage) {
               kmehrmessage.setHeader(createHeader("20110701"));
           }
       
           public Kmehrmessage createTransactionSetMessage(int latestMedicationSchemeVersion, string localId) {
               MarshallerHelper kmehrRequestMarshaller = new MarshallerHelper(typeof(Kmehrmessage), typeof(Kmehrmessage));
               Map velocityContext = new HashMap();
               velocityContext.put("latestMedicationSchemeVersion", latestMedicationSchemeVersion++);
               velocityContext.put("today", DateTimeFormat.forPattern("yyyy-MM-dd").print(new org.joda.time.DateTime()));
               velocityContext.put("idToday", DateTimeFormat.forPattern("yyyyMMdd").print(new org.joda.time.DateTime()));
       		   if (localId != null) {
               		velocityContext.put("localId", "<id S=\"LOCAL\" SV=\"1.0\" SL=\"RSWID\">" + localId + "</id>");
       		   }
               string kmehr =  TemplateEngineUtils.generate(velocityContext , ".\\requests\\" + testFilesLocation + "\\PutTransactionSet - request.xml");
               return (Kmehrmessage) kmehrRequestMarshaller.toObject(kmehr);
       
           }
           
           public Kmehrmessage createTransactionSetMessage(int latestMedicationSchemeVersion) {
               return createTransactionSetMessage(latestMedicationSchemeVersion, null);
    	   }
      
       
           /**
            * Create a transaction type needed for transaction operations
            */
           private TransactionType createTransactionType(string transactionId, string xml) {
               MarshallerHelper helper = new MarshallerHelper(typeof(TransactionType), typeof(TransactionType));
               TransactionType transaction = (TransactionType) helper.toObject(xml);
               AuthorType author = new AuthorType();
               author.getHcparties().addAll(createSender().getHcparties());
               transaction.setAuthor(author);
       
               transaction.getIds().add(createIdKmehr(null, "1.0", transactionId, IDKMEHRschemes.ID_KMEHR));
               return transaction;
           }
       
       
           /**
            * Create a transactionWithPeriod type for transaction operations
            */
           public TransactionWithPeriodType createTransactionWithPeriodType() {
               TransactionWithPeriodType transaction = new TransactionWithPeriodType();
               CDTRANSACTION cdtransactionMedicationScheme = getCdtransaction("1.6", "medicationscheme");
               CDTRANSACTION cdtransactionSumehr = getCdtransaction("1.6", "sumehr");
               transaction.getCds().add(cdtransactionMedicationScheme);
               transaction.getCds().add(cdtransactionSumehr);
           
               return transaction;
           }
           
           public TransactionWithPeriodType createTransactionWithPeriodTypeWithoutFilter() {
               return new TransactionWithPeriodType();
           }
       
           private CDTRANSACTION getCdtransaction(string value, string medicationscheme) {
               CDTRANSACTION cdtransactionMedicationScheme = new CDTRANSACTION();
               cdtransactionMedicationScheme.setS(CDTRANSACTIONschemes.CD_TRANSACTION);
               cdtransactionMedicationScheme.setSV(value);
               cdtransactionMedicationScheme.setValue(medicationscheme);
               return cdtransactionMedicationScheme;
           }
       
           /**
            * Create a transaction base type for transaction operations
            */
           public TransactionBaseType createTransactionBaseType(string uri, string value) {
               TransactionBaseType transaction = new TransactionBaseType();
               transaction.setId(createIdKmehr(uri, "1.0", value, IDKMEHRschemes.LOCAL));
               return transaction;
           }
           
           public SelectGetLatestUpdateType createSelectGetLatestUpdateType() {
               SelectGetLatestUpdateType selectGetLatestUpdateType = new SelectGetLatestUpdateType();
               Criteria criteria = new Criteria();
               criteria.setPatient(createPatientIdType());
               CDTRANSACTION cdtransaction = getCdtransaction("1.4", "medicationscheme");
               criteria.getCds().add(cdtransaction);
               selectGetLatestUpdateType.getCriterias().add(criteria);
               return selectGetLatestUpdateType;
           }
       
           public TransactionIdType createTransactionIdType(string transactionId) {
               TransactionIdType transaction = new TransactionIdType();
               transaction.getIds().add(createIdKmehr(null, "1.0", transactionId, IDKMEHRschemes.LOCAL));
               return transaction;
           }
           
           
 
	    public Integer getLatestMedicationSchemeVersion(GetLatestUpdateResponse latestUpdateResponse) {
	    	java.util.List latestUpdates = latestUpdateResponse.getLatestupdatelist().getLatestupdates();
	    	for (int i = 0; i<latestUpdates.size(); i++) {
				Latestupdate latestupdate = (Latestupdate) latestUpdates.get(i);
                if ("medicationscheme".Equals(latestupdate.getCd().getValue())) {
					return new Integer(latestupdate.getVersion());
                }
            }
	    	return null;
        }
       
           private AddressType createAddress() {
               AddressType address = new AddressType();
               address.setCity("");
               CDADDRESS cdAddress = new CDADDRESS();
               cdAddress.setS(CDADDRESSschemes.CD_ADDRESS);
               cdAddress.setSV("1.0");
               cdAddress.setValue("");
               address.getCds().add(cdAddress);
               CountryType country = new CountryType();
               CDCOUNTRY cdCountry = new CDCOUNTRY();
               cdCountry.setS(CDCOUNTRYschemes.CD_COUNTRY);
               cdCountry.setSV("1.0");
               cdCountry.setValue("");
               country.setCd(cdCountry);
               address.setCountry(country);
               address.setDistrict("");
               address.setHousenumber("");
               address.setNis("");
               address.setPostboxnumber("");
               address.setStreet("");
               address.setZip("");
               return address;
           }
       
           private TelecomType createTelecom() {
               TelecomType telecom = new TelecomType();
               telecom.setTelecomnumber("");
               CDTELECOM cdTelecom = new CDTELECOM();
               cdTelecom.setS(CDTELECOMschemes.CD_TELECOM);
               cdTelecom.setSV("1.0");
               cdTelecom.setValue("");
               telecom.getCds().add(cdTelecom);
               return telecom;
           } 
	}
}
