/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.tests.beid;

import java.io.IOException;

import javax.smartcardio.CardException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fedict.commons.eid.client.BeIDCard;
import be.fedict.commons.eid.client.FileType;
import be.fgov.ehealth.technicalconnector.tests.beid.tlv.TLVFileGenerator;
import be.fgov.ehealth.technicalconnector.tests.beid.tlv.XmlEidViewerTLVFileGenerator;
import be.fgov.ehealth.technicalconnector.tests.beid.tlv.XmlTestCardTLVFileGenerator;


/**
 * Dummy BEID card
 *
 * @author EHP
 */
public class DummyBeIDCard extends BeIDCard {

    private static final Logger LOG = LoggerFactory.getLogger(DummyBeIDCard.class);

    private String location;

    private static TLVFileGenerator[] generators;

    static {
        generators = new TLVFileGenerator[]{new XmlEidViewerTLVFileGenerator(), new XmlTestCardTLVFileGenerator()};
    }

    public DummyBeIDCard(String location) throws TechnicalConnectorException {
        super(new DummyCard());
        this.location = location;
    }

    /**
     * @see be.fedict.commons.eid.client.BeIDCard#readFile(be.fedict.commons.eid.client.FileType)
     */
    @Override
    public byte[] readFile(FileType fileType) throws CardException, IOException, InterruptedException {
        byte[] file = null;
        int i = 0;
        while (file == null) {
            if (generators.length > i) {
                file = generators[i].generate(fileType, location);
                i++;
            } else {
                throw new CardException("Unable to find file of type " + fileType.name());
            }
        }
        return file;
    }


}
