package be.ehealth.technicalconnector.session;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.service.sts.utils.SAMLHelper;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

import java.util.concurrent.TimeUnit;

import static be.ehealth.technicalconnector.session.renew.RenewStrategy.PROP_AUTO_RENEW;
import static be.ehealth.technicalconnector.session.renew.SlidingWindowRenewStrategy.SLIDING_WINDOW_DIVIDER;

public class SlidingWindowSessionManagerIntegrationTest extends AbstractSessionManagerIntegrationTest {

    @ClassRule
    public static SessionRule rule = SessionRule.withInactiveSession()
            .build();

    @Test
    public void test() throws Exception {

        ConfigFactory.getConfigValidator().setProperty(SLIDING_WINDOW_DIVIDER, "2400");
        ConfigFactory.getConfigValidator().setProperty(PROP_AUTO_RENEW, "true");
        SessionManager sessionmgmgt = Session.getInstance();

        sessionmgmgt.unloadSession();
        SessionItem session = sessionmgmgt.createFallbackSession(props.getProperty("test.session.holderofkey.password"), props.getProperty("test.session.encryption.password"));
        DateTime beforeRenew = SAMLHelper.getNotOnOrAfterCondition(session.getSAMLToken().getAssertion());

        TimeUnit.SECONDS.sleep(60);

        DateTime afterRenew = SAMLHelper.getNotOnOrAfterCondition(sessionmgmgt.getSession().getSAMLToken().getAssertion());
        Assert.assertTrue("SlidingWindow Renew doesn't work!", afterRenew.isAfter(beforeRenew));
        sessionmgmgt.unloadSession();

    }
}
