/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.adapter;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;


/**
 * Unit test for {@link XmlDateTimeAdapter}
 *
 * @author Olivier Chapuis (eh077))
 */
public class XmlDateTimeAdapterTest {

    @Test
    public void testDateCreatedInOtherTimezonePrintDateTime() throws Exception {
        XmlDateTimeAdapter xmlDateTimeAdapter = new XmlDateTimeAdapter();
        DateTime parsedDateTimeZonePlusOneJanuary = xmlDateTimeAdapter.unmarshal("2013-01-01+01:00");
        DateTime parsedDateTimeZonePlusOneMay = xmlDateTimeAdapter.unmarshal("2013-05-01+01:00");
        Assert.assertEquals("2013-01-01T00:00:00+01:00", xmlDateTimeAdapter.marshal(parsedDateTimeZonePlusOneJanuary));
        Assert.assertEquals("2013-05-01T00:00:00+01:00", xmlDateTimeAdapter.marshal(parsedDateTimeZonePlusOneMay)); // loses the
                                                                                                                               // timezone
    }

    @Test
    public void testDateTimeCreatedInOtherTimezone() throws Exception {
        XmlDateTimeAdapter xmlDateTimeAdapter = new XmlDateTimeAdapter();
        DateTime parsedDateTimeZonePlusOneJanuary = xmlDateTimeAdapter.unmarshal("2013-01-01T00:00:00+01:00");
        DateTime parsedDateTimeZonePlusOneMay = xmlDateTimeAdapter.unmarshal("2013-05-01T01:00:00+02:00");
        Assert.assertEquals("2013-01-01T00:00:00+01:00", xmlDateTimeAdapter.marshal(parsedDateTimeZonePlusOneJanuary));
        Assert.assertEquals("2013-05-01T01:00:00+02:00", xmlDateTimeAdapter.marshal(parsedDateTimeZonePlusOneMay)); // loses the
                                                                                                                               // timezone
    }

    @Test
    public void testDatesCreatedInDifferentTimesOfYear() throws Exception {
        XmlDateTimeAdapter xmlDateTimeAdapter = new XmlDateTimeAdapter();
        DateTime parsedDateTimeZonePlusOneJanuary = xmlDateTimeAdapter.unmarshal("2013-01-01T00:00:00+01:00");
        DateTime parsedDateTimeZonePlusOneMay = xmlDateTimeAdapter.unmarshal("2013-05-01T01:00:00+01:00");
        Assert.assertEquals("2013-01-01T00:00:00+01:00", xmlDateTimeAdapter.marshal(parsedDateTimeZonePlusOneJanuary));
        Assert.assertEquals("2013-05-01T01:00:00+01:00", xmlDateTimeAdapter.marshal(parsedDateTimeZonePlusOneMay));
    }

    @Test
    public void testPrintDateTimeNull() throws Exception {
        Assert.assertNull(new XmlDateTimeAdapter().marshal(null));
    }
}
