/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.wsconsent.service;

import org.junit.Assert;
import org.junit.Test;

import be.fgov.ehealth.hubservices.core.v2.ConsentType;
import be.fgov.ehealth.hubservices.core.v2.GetPatientConsentResponse;
import be.fgov.ehealth.hubservices.core.v2.PutPatientConsentResponse;
import be.fgov.ehealth.hubservices.core.v2.RevokePatientConsentResponse;
import be.fgov.ehealth.technicalconnector.tests.utils.AssumeTools;


/**
 * integration test for the wsconsent connector. will test some scenarios.
 * 
 * @author EHP
 * 
 * 
 * 
 */
public class WsConsentServiceFullScenarioUserIntegrationTest extends AbstractWsConsentServiceIntegrationTest {


    @Test
    public void testFullScenario() throws Exception {
        AssumeTools.isEIDEnabled();
        // clean all active consents
        cleanConsents();

        // Put a consent : should succeed
        ConsentType firstConsent = createNewConsentTypeForCurrentPatientAndAuthor();
        PutPatientConsentResponse firstPutConsentResponse = putConsentForCurrentPatient(firstConsent);
        checkIfSuccessFull(firstPutConsentResponse);

        // Put second consent : should return with error that it already exists
        ConsentType secondConsent = createNewConsentTypeForCurrentPatientAndAuthor();
        PutPatientConsentResponse secondPutConsentResponse = putConsentForCurrentPatient(secondConsent);
        checkErrorMessage(secondPutConsentResponse, "Consent already exists for the patient");

        // Get consent : should return the first created consent ( same id ) , same contents
        GetPatientConsentResponse retrievedConsentResponse = retrievePatientConsentResponse();
        ConsentType retrievedActiveConsent = retrievedConsentResponse.getConsent();


        checkIfEqual(firstConsent, retrievedActiveConsent);

        // revokeConsent : should revoke the consent
        RevokePatientConsentResponse revokePatientconsentResponse = revokePatientconsent(retrievedActiveConsent);
        checkIfSuccesFull(revokePatientconsentResponse);

        // Get consent : now should not return any consent
        GetPatientConsentResponse retrievePatientConsentResponseAfterRevoke = retrievePatientConsentResponse();
        Assert.assertNull(retrievePatientConsentResponseAfterRevoke.getConsent());

        // revoke consent : since already revoked :should return error message
        RevokePatientConsentResponse revokePatientconsentResponseTwiceRevoked = revokePatientconsent(retrievedActiveConsent);
        checkErrorMessage(revokePatientconsentResponseTwiceRevoked, "No active consent for the patient");

    }

    @Test
    public void testFullScenarioWithSessionService() throws Exception {
        AssumeTools.isEIDEnabled();
        // clean all active consents
        cleanConsents();

        // Put a consent : should succeed
        ConsentType firstConsent = createNewConsentTypeForCurrentPatientAndAuthor();
        PutPatientConsentResponse firstPutConsentResponse = putConsentForCurrentPatientWithSessionService(firstConsent);
        checkIfSuccessFull(firstPutConsentResponse);

        // Put second consent : should return with error that it already exists
        ConsentType secondConsent = createNewConsentTypeForCurrentPatientAndAuthor();
        PutPatientConsentResponse secondPutConsentResponse = putConsentForCurrentPatientWithSessionService(secondConsent);
        checkErrorMessage(secondPutConsentResponse, "Consent already exists for the patient");

        // Get consent : should return the first created consent ( same id ) , same contents
        GetPatientConsentResponse retrievedConsentResponse = retrievePatientConsentResponseWithSessionService();
        ConsentType retrievedActiveConsent = retrievedConsentResponse.getConsent();
        checkIfEqual(firstConsent, retrievedActiveConsent);

        // revokeConsent : should revoke the consent
        RevokePatientConsentResponse revokePatientconsentResponse = revokePatientconsentWithSessionService(retrievedActiveConsent);
        checkIfSuccesFull(revokePatientconsentResponse);

        // Get consent : now should not return any consent
        GetPatientConsentResponse retrievePatientConsentResponseAfterRevoke = retrievePatientConsentResponseWithSessionService();
        Assert.assertNull(retrievePatientConsentResponseAfterRevoke.getConsent());

        // revoke consent : since already revoked :should return error message
        RevokePatientConsentResponse revokePatientconsentResponseTwiceRevoked = revokePatientconsentWithSessionService(retrievedActiveConsent);
        checkErrorMessage(revokePatientconsentResponseTwiceRevoked, "No active consent for the patient");

    }


}
