/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.wsconsent.builders;

import org.junit.Assert;
import org.junit.Test;

import be.ehealth.businessconnector.wsconsent.builders.impl.PatientInfoBuilderImpl;
import be.fgov.ehealth.hubservices.core.v2.PatientIdType;
import be.fgov.ehealth.standards.kmehr.id.v1.IDPATIENTschemes;
import be.fgov.ehealth.technicalconnector.tests.utils.AssumeTools;


/**
 * PatientInfoBuilderImplIntegrationTest class test.
 * 
 * @author EHP
 * 
 * 
 * 
 */
public class PatientInfoBuilderImplUserIntegrationTest {

    private PatientInfoBuilder builder = new PatientInfoBuilderImpl();


    @Test
    public void testPatientInfoBuilder() throws Exception {
        AssumeTools.isEIDEnabled();
        PatientIdType patient = builder.readFromEidCard();
        // INSS
        Assert.assertEquals(IDPATIENTschemes.INSS, patient.getIds().get(0).getS());
        Assert.assertNotNull(patient.getIds().get(0).getValue());
        Assert.assertNotNull(patient.getFirstname());
        Assert.assertNotNull(patient.getFamilyname());
        // Eid
        Assert.assertEquals(IDPATIENTschemes.EID_CARDNO, patient.getIds().get(1).getS());
        Assert.assertNotNull(patient.getIds().get(1).getValue());
    }
}
