/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.therlink;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.unitils.reflectionassert.ReflectionAssert;

import be.ehealth.business.common.domain.Patient;
import be.ehealth.business.common.util.EidUtils;
import be.ehealth.businessconnector.therlink.domain.HcParty;
import be.ehealth.businessconnector.therlink.domain.Proof;
import be.ehealth.businessconnector.therlink.domain.requests.PutTherapeuticLinkRequest;
import be.ehealth.businessconnector.therlink.mappers.PatientMapper;
import be.ehealth.businessconnector.therlink.util.ConfigReader;
import be.fgov.ehealth.technicalconnector.tests.utils.AssumeTools;


/**
 * integration test for {@link DefaultImplementationForgeneralPractitioner}.
 * 
 * @author EHP
 * 
 */
public class DefaultImplementationForgeneralPractitionerUserIntegrationTest extends AbstractDefaultImplementationPersphysician {

    private static final String GPCONSULTATION = "gpconsultation";

    @BeforeClass
    public static void checkEidEnabled() {
        AssumeTools.isEIDEnabled();
    }

    /**
     * @throws Exception
     */
    @Test
    public void testCreateDefaultTherapeuticLinkWithEidReading() throws Exception {
        PutTherapeuticLinkRequest request = DefaultImplementationForgeneralPractitioner.createDefaultTherapeuticLinkWithEidReading();
        Assert.assertNotNull(request);
        HcParty hcp = ConfigReader.getCareProvider();
        Patient patient = PatientMapper.mapPatient(EidUtils.readFromEidCard());
        ReflectionAssert.assertLenientEquals(patient, request.getLink().getPatient());
        ReflectionAssert.assertLenientEquals(hcp, request.getLink().getHcParty());
        Assert.assertEquals(GPCONSULTATION, request.getLink().getType());
    }


    /**
     * @throws Exception
     */
    @Test
    public void testCreateDefaultTherapeuticLinkWithEidSigning() throws Exception {
        PutTherapeuticLinkRequest request = DefaultImplementationForgeneralPractitioner.createDefaultTherapeuticLinkWithEidSigning();
        Assert.assertNotNull(request);
        HcParty hcp = ConfigReader.getCareProvider();
        Patient patient = PatientMapper.mapPatient(EidUtils.readFromEidCard());
        ReflectionAssert.assertLenientEquals(patient, request.getLink().getPatient());
        ReflectionAssert.assertLenientEquals(hcp, request.getLink().getHcParty());
        Assert.assertNotNull(request.getProofs());
        Assert.assertEquals(1, request.getProofs().size());
        Proof proof = request.getProofs().get(0);
        Assert.assertNotNull(proof);
        Assert.assertEquals("eidsigning", proof.getType());
        Assert.assertEquals(GPCONSULTATION, request.getLink().getType());
    }
}
