package be.ehealth.businessconnector.mycarenet.memberdatav2.session;

import be.ehealth.business.mycarenetdomaincommons.domain.InputReference;
import be.ehealth.businessconnector.mycarenet.memberdatav2.session.builders.BuilderStrategy;
import be.ehealth.businessconnector.mycarenet.memberdatav2.session.builders.impl.EncryptedBuilderStrategy;
import be.ehealth.businessconnector.mycarenet.memberdatav2.session.builders.impl.UnencryptedBuilderStrategy;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.mycarenet.memberdata.protocol.v1.MemberDataConsultationRequest;

public abstract class AbstractIntegrationTest {

    protected static final BuilderStrategy ENCRYPTED_STRATEGY = new EncryptedBuilderStrategy();

    protected static final BuilderStrategy UNENCRYPTED_STRATEGY = new UnencryptedBuilderStrategy();

    protected MemberDataConsultationRequest buildRequest(String inputRef, BuilderStrategy strategy, Object content) throws Exception {
        ConnectorXmlUtils.dump(content);

        // input reference and AttributeQuery ID must match
        InputReference inputReference = new InputReference(inputRef);

        return strategy.build(true, inputReference, content);
    }

}
