package be.ehealth.businessconnector.hub.session;

import java.util.Properties;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleProxy;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.session.Session;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;
import be.fgov.ehealth.technicalconnector.tests.utils.TestPropertiesLoader;

/**
 * Class that will encapsulate methods that will create the information needed for the test.
 * 
 * @author EH054
 */
public abstract class AbstractIntrahubIntegrationTest {

    private static Configuration technicalConfig;
    
    protected static Properties props;

    protected static HubServiceComplete hubServiceComplete;

    protected static String transactionId;

    @BeforeClass
    public static void init() throws Exception {
        SessionInitializer.init("/be.ehealth.businessconnector.intrahub.test.properties");
        props = TestPropertiesLoader.getProperties("/be.ehealth.businessconnector.intrahub.test.properties");

        technicalConfig = ConfigFactory.getConfigValidator().getConfig();
        new ConfigurationModuleProxy().init(technicalConfig);

        HubTestHelper.initHub(HubConfig.CHOSENHUB_ID, props);
        hubServiceComplete = HubSessionServiceFactory.getHubServiceComplete();
    }

    @AfterClass
    public static void teardownIntrahubSession() throws Exception {
        Session.getInstance().unloadSession();
    }

    @Before
    public void initTransactionId() throws TechnicalConnectorException {
        transactionId = IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.UUID).generateId();
    }

}
