package be.ehealth.businessconnector.geninsasync.session;

import be.cin.nip.async.generic.Post;
import be.cin.nip.async.generic.PostResponse;
import be.ehealth.businessconnector.genericasync.helper.PostTestHelper;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Collection;


/**
 * <p>Runs the post requests for the integration test scenarios specified by MyCareNet. You can of course add your own test files.</p>
 *    
 * <p>For the requests to be valid the following editing must be done to the supplied 920000 test files before performing a post operation.
 * The structure of the 920000 message can be found in http://www.inami.fgov.be/SiteCollectionDocuments/instructions_facturation_electronique.pdf  </p>
 * The templating engine is used to edit the template test files located in test resources folder <code>/invoicing/request/"</code>
 * </p>
 *     
 * Steps for scenarios 2 to 6:
 * <ul>
 *  <li>Change the <code>nihii</code> with the n° of your choice. It will be set by the templating engine in:</li>
 *  <ul>
 *            <li>record 10 + 20 + 25 + 80 + 90, zone 14 every time</li>
 *            <li>record 50 et 51, zone 15</li>
 *  </ul>   
 *  <ul>
 *   <li>increment <code>sendingNumber</code>: It will be set in record 10, zone 7 (start with 001, 002, 003, and so on)</li>
 *   <li>The date of the day is set in the <code>invoiceDate</code>, record 10, zone 25-26 and also in record 51 zone 55</li>
 *  </ul>
 *
 * Additional steps for scenarios 7 to 10:
 * <ul>
 *  <li>Perform a tariff consultation as defined in the scenario.</li>
 * </ul> 
 *  From the response of this tariff consultation:
 * <ul>
 *  <li>Retrieve the agreement number (see the financialcontract item) and set it in <code>agreementNumber</code>: the value will be set in record 51, zone 42-45.</li>
 *  <li>Retrieve the encounter date and set it in <code>agreementNumber</code>: the value will be set in record 50, zone 5 and also 6a-6b.</li>
 *  <li>Put the month of the encounter date in in <code>yearMonthEncounterDate</code>:  the value will be set record 10, zone 23.</li>
 * </ul>
 * 
 * @author EHP
 */

@RunWith(Parameterized.class)
public class GenInsPostGenericAsyncIntegrationTest {

    private static final Logger LOG = LoggerFactory.getLogger(GenInsPostGenericAsyncIntegrationTest.class);

    private static final String PROJECT_NAME = "genins";
    private static final String XML_REQUEST_FOLDER = "/examples/genins/async/";
    private static final String MESSAGE_NAME = "INSX";


    private String oa;

    @Rule
    public SessionRule rule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.geninsasync.test.properties").build();

    PostTestHelper testHelper = PostTestHelper.Builder().projectName(PROJECT_NAME).withXades(false).isTest(false).build();

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        Collection<Object[]> testData = new ArrayList<Object[]>();
        testData.add(new Object[]{"OA100"});
        testData.add(new Object[]{"OA300"});
        testData.add(new Object[]{"OA500"});
        testData.add(new Object[]{"OA600"});
        testData.add(new Object[]{"OA900"});

        return testData;
    }

    public GenInsPostGenericAsyncIntegrationTest(String oa) {
        this.oa = oa;
    }

    @Test
    public void performPostRequestTest() throws Exception {
        performPost(ConnectorIOUtils.getResourceAsByteArray(XML_REQUEST_FOLDER + "ValidRequest_" + oa + ".xml"),
                PROJECT_NAME,
                MESSAGE_NAME);
    }

    @Test
    public void performPosRequestTest() throws Exception {
        performPost(ConnectorIOUtils.getResourceAsByteArray(XML_REQUEST_FOLDER + "InvalidRequestPeriod_" + oa + ".xml"),
                PROJECT_NAME,
                MESSAGE_NAME);
    }


    public void performPost(byte[] contentBytes, String serviceName, String messageName) throws Exception {
        Post post = testHelper.buildPostRequest(contentBytes, messageName);
        PostResponse responsePost = testHelper.post(serviceName, post);
        testHelper.validateResponse(responsePost);
    }
}
