/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.genericasync.test.util;

import be.cin.nip.async.generic.TAck;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.utils.DateUtils;
import be.ehealth.technicalconnector.utils.SessionUtil;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.regex.Matcher;


/**
 * some utility methods for gen async tests.
 * 
 * @author EHP
 * 
 */
public final class TestUtil {


    private static final Logger LOG = LoggerFactory.getLogger(TestUtil.class);

    public static void addTackToSb(StringBuilder sb, TAck tAck) {
        sb.append("\n").append(tAck.getAppliesTo()).append("\t").append(tAck.getId()).append("\t").append(tAck.getIssuer()).append("\t").append(tAck.getResultMajor()).append("\t").append(tAck.getResultMinor()).append("\t").append(tAck.getResultMessage());
    }


    /**
     * hide constructor.
     */
    private TestUtil() {
        super();
    }


    /**
     * @param xmlTemplate
     * @return
     */
    public static String fillOutPlaceHolders(String xmlTemplate) throws TechnicalConnectorException {
        String output = xmlTemplate;
        output = replaceString(output, "$$doctor.nihi.number$$", SessionUtil.getNihii11());
        output = replaceString(output, "$$doctor.inss.number$$", SessionUtil.getNiss());
        output = replaceString(output, "$$doctor.firstname$$", SessionUtil.getFirstname());
        output = replaceString(output, "$$doctor.lastname$$", SessionUtil.getLastname());
        final DateTime dateTime = new DateTime();

        output = replaceString(output, "$$date.today$$", DateUtils.printDate(dateTime));
        output = replaceString(output, "$$date.today.withouttimezone$$", DateUtils.printDateWithoutTimeZone(dateTime));
        output = replaceString(output, "$$time.today$$", DateUtils.printTime(dateTime));
        output = replaceString(output, "$$generated.id$$", IdGeneratorFactory.getIdGenerator().generateId());
        LOG.debug("filled out template : " + output);
        return output;
    }


    /**
     * @param input
     * @param stringToReplace
     * @param replacementString
     * @return
     */
    public static String replaceString(String input, final String stringToReplace, final String replacementString) {
        return input.replaceAll(Matcher.quoteReplacement(stringToReplace), replacementString);
    }

}
