/*
 * Copyright (c) Smals
 */
package be.ehealth.businessconnector.genericasync.mappers;

import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.unitils.UnitilsJUnit4TestClassRunner;
import org.unitils.reflectionassert.ReflectionAssert;
import org.unitils.reflectionassert.ReflectionComparatorMode;

import be.cin.mycarenet.esb.common.v2.CareProviderType;
import be.cin.mycarenet.esb.common.v2.IdType;
import be.cin.mycarenet.esb.common.v2.LicenseType;
import be.cin.mycarenet.esb.common.v2.NihiiType;
import be.cin.mycarenet.esb.common.v2.OrigineType;
import be.cin.mycarenet.esb.common.v2.PackageType;
import be.cin.mycarenet.esb.common.v2.ValueRefString;
import be.ehealth.business.mycarenetdomaincommons.domain.CareProvider;
import be.ehealth.business.mycarenetdomaincommons.domain.CommonInput;
import be.ehealth.business.mycarenetdomaincommons.domain.Identification;
import be.ehealth.business.mycarenetdomaincommons.domain.McnPackageInfo;
import be.ehealth.business.mycarenetdomaincommons.domain.Nihii;
import be.ehealth.business.mycarenetdomaincommons.domain.Origin;

/**
 * tests the mapping of the commonInput mycarenet object to the project specific common input jaxb object.
 * 
 * @author EHP
 * 
 */
@RunWith(UnitilsJUnit4TestClassRunner.class)
public class CommonInputMapperTest {

    private static final String SSIN = "ssin";

    private static final String NAME1 = "name1";

    private static final String SSIN_VALUE = "123456789";

    private static final String QUALITY = "quality";

    private static final String SITE_ID = "siteId";

    private static final String PACKAGE_NAME = "name";

    private static final String LICENSE_PASSWORD = "password";

    private static final String LICENSE_USERNAME = "userName";

    private static final String INPUTREFERENCE = "inputRefernce";

    private static CareProvider mcnCareProvider;

    private static McnPackageInfo mcnPackageInfo;


    @BeforeClass
    public static void init() {
        mcnCareProvider = new CareProvider(new Nihii(QUALITY, SSIN_VALUE));
        mcnCareProvider.setOrganization(new Identification(NAME1, null, SSIN, null));
        mcnCareProvider.setPhysicalPerson(new Identification(NAME1, null, SSIN, null));
        mcnPackageInfo = new McnPackageInfo(LICENSE_USERNAME, LICENSE_PASSWORD, PACKAGE_NAME);
    }

    @Test
    public void testMappingOrigin() throws Exception {
        OrigineType expected = new OrigineType();
        expected.setCareProvider(createCareProvider());
        expected.setPackage(createPackage(PACKAGE_NAME, LICENSE_PASSWORD, LICENSE_USERNAME));
        expected.setSiteID(createValueRefString(SITE_ID));

        Origin origin = new Origin(mcnPackageInfo, SITE_ID, null);
        origin.setCareProvider(mcnCareProvider);

        OrigineType actual = CommonInputMapper.mapOrigin(origin);

        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.IGNORE_DEFAULTS);
    }

    @Test
    public void testMappingCommonInput() {
        Origin origin = new Origin(mcnPackageInfo, mcnCareProvider);
        CommonInput commonInput = new CommonInput(false, origin, INPUTREFERENCE);

        be.cin.mycarenet.esb.common.v2.CommonInput actual = CommonInputMapper.mapCommonInputType(commonInput);

        be.cin.mycarenet.esb.common.v2.CommonInput expected = new be.cin.mycarenet.esb.common.v2.CommonInput();
        expected.setInputReference(INPUTREFERENCE);
        expected.setNIPReference(null);
        OrigineType expectedOrigin = new OrigineType();
        PackageType expectedPackageType = createPackage(PACKAGE_NAME, LICENSE_PASSWORD, LICENSE_USERNAME);
        expectedOrigin.setPackage(expectedPackageType);
        CareProviderType expectedCareProvider = createCareProvider();
        expectedOrigin.setCareProvider(expectedCareProvider);
        expected.setOrigin(expectedOrigin);
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.IGNORE_DEFAULTS);
    }

    private PackageType createPackage(String packageName, String licensePassword, String licenceUsername) {
        PackageType expectedPackageType = new PackageType();
        ValueRefString packageNameValueRef = createValueRefString(packageName);
        expectedPackageType.setName(packageNameValueRef);
        LicenseType licenseType = new LicenseType();
        licenseType.setPassword(licensePassword);
        licenseType.setUsername(licenceUsername);
        expectedPackageType.setLicense(licenseType);
        return expectedPackageType;
    }

    private CareProviderType createCareProvider() {
        CareProviderType expectedCareProvider = new CareProviderType();
        expectedCareProvider.setNihii(createNihiiType(mcnCareProvider.getNihii().getQuality(), mcnCareProvider.getNihii().getValue()));
        IdType physicalPerson = new IdType();
        physicalPerson.setName(createValueRefString(mcnCareProvider.getPhysicalPerson().getName()));
        physicalPerson.setSsin(createValueRefString(mcnCareProvider.getPhysicalPerson().getSsin()));
        IdType organisation = physicalPerson;
        organisation.setName(createValueRefString(mcnCareProvider.getOrganization().getName()));
        organisation.setSsin(createValueRefString(mcnCareProvider.getOrganization().getSsin()));
        expectedCareProvider.setOrganization(organisation);
        expectedCareProvider.setPhysicalPerson(physicalPerson);
        return expectedCareProvider;
    }

    public ValueRefString createValueRefString(String value) {
        ValueRefString packageNameValueRef = new ValueRefString();
        packageNameValueRef.setValue(value);
        return packageNameValueRef;
    }

    private NihiiType createNihiiType(String quality, String value) {
        NihiiType nihii = new NihiiType();
        nihii.setQuality(quality);
        ValueRefString valueRefStr = new ValueRefString();
        valueRefStr.setValue(value);
        nihii.setValue(valueRefStr);
        return nihii;
    }

}
