/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.ehbox.v3.util;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * maps given group to the quality and identifier needed in ehbox. test only.
 * 
 * @author EHP
 * 
 */
public final class QualityMapper {

    private static final Logger LOG = LoggerFactory.getLogger(QualityMapper.class);

    private static final QualityMapper GROUP = new QualityMapper("group", "GROUP", "NIHII");

    private static final QualityMapper PERPHYSICIAN = new QualityMapper("persphysician", "DOCTOR", "INSS");

    private static final QualityMapper PERSNURSE = new QualityMapper("persnurse", "NURSE", "INSS");

    private static final QualityMapper PERDENTIST = new QualityMapper("persdentist", "DENTIST", "INSS");

    private static final QualityMapper PHARMACY = new QualityMapper("orgpharmacy", "PHARMACIST", "INSS");

    private static final QualityMapper PHYSIOTHERAPIST = new QualityMapper("physiotherapist", "PHYSIOTHERAPIST", "INSS");

    private static final QualityMapper DEPTPHARMACY = new QualityMapper("deptpharmacy", "PHARMACY", "NIHII");

    /*
     * groupDoctor("GROUP_DOCTORS","NIHII"), guardPost("GUARD_POST","NIHII"), homeService("HOME_SERVICES","NIHII"),
     * hospital("HOSPITAL","NIHII"), institution("INSTITUTION","CBE"), institutionEhp("INSTITUTION_EHP","EHP"), labo("LABO","NIHII"),
     * medicalHouse("MEDICAL_HOUSE","NIHII"), officeDentist("OFFICE_DENTISTS","NIHII"), officeDoctors("OFFICE_DOCTORS","NIHII"),
     * ofBand("OF_BAND","NIHII"), ofPhysios("OF_PHYSIOS","NIHII"), ctrlOrganismEhp("CTRL_ORGANISM_EHP","EHP"),
     * otdPharmacy("OTD_PHARMACY","NIHII"), palliativeCare("PALLIATIVE_CARE","NIHII"), pharmacy("PHARMACY","NIHII"),
     * protAcc("PROT_ACC","NIHII"), psychHouse("PSYCH_HOUSE","NIHII"), retirement("RETIREMENT","NIHII"),
     * treatmentCenter("TREATMENT_CENTER","CBE"), ambulanceRescuer("AMBULANCE_RESCUER","INSS"), audicien("AUDICIEN","INSS"),
     * audiologist("AUDIOLOGIST","INSS"), familyScienceBachelor("FAMILY_SCIENCE_BACHELOR","INSS"),
     * readaptationBachelor("READAPTATION_BACHELOR","INSS"), trussMaker("TRUSS_MAKER","INSS"), citizen("CITIZEN","INSS"),
     * dentist("DENTIST","INSS"), dietetician("DIETICIAN","INSS"), doctor("DOCTOR","INSS"), implantProvider("IMPLANTPROVIDER","INSS"),
     * labTechnologist("LAB_TECHNOLOGIST","INSS"), logopedist("LOGOPEDIST","INSS"), appliedPsychBachelor("APPLIED_PSYCH_BACHELOR","INSS"),
     * gerontologyMaster("GERONTOLOGY_MASTER","INSS"), psychomotorTherapy("PSYCHOMOTOR_THERAPY","INSS"),
     * imagingTechnologist("IMAGING_TECHNOLOGIST","INSS"), midwife("MIDWIFE","INSS"), nurse("NURSE","INSS"),
     * occupationalTherapist("OCCUPATIONAL_THERAPIST","INSS"), optitien("OPTICIEN","INSS"),
     * orthopedagogistMaster("ORTHOPEDAGOGIST_MASTER","INSS"), orthopedist("ORTHOPEDIST","INSS"), orthopist("ORTHOPTIST","INSS"),
     * pediatricNurse("PEDIATRIC_NURSE","INSS"), pharmacist("PHARMACIST","INSS"), phamacistAssistant("PHARMACIST_ASSISTANT","INSS"),
     * psychologist("PSYCHOLOGIST","INSS"), physiotherapist("PHYSIOTHERAPIST","INSS"), podologist("PODOLOGIST","INSS"),
     * practicalNurse("PRACTICALNURSE","INSS"), socialWorker("SOCIAL_WORKER","INSS"), specializedEducator("SPECIALIZED_EDUCATOR","INSS");
     */

    private String quality;

    private String type;

    private String professionType;

    private static Map<String, QualityMapper> mapper = new HashMap<String, QualityMapper>();

    static {
        mapper.put(GROUP.professionType, GROUP);
        mapper.put(PERPHYSICIAN.professionType, PERPHYSICIAN);
        mapper.put(PERSNURSE.professionType, PERSNURSE);
        mapper.put(PERDENTIST.professionType, PERDENTIST);
        mapper.put(PHARMACY.professionType, PHARMACY);
        mapper.put(PHYSIOTHERAPIST.professionType, PHYSIOTHERAPIST);
        mapper.put(DEPTPHARMACY.professionType, DEPTPHARMACY);
    }

    public static QualityMapper getMapper(String professionType) {
        if (mapper.containsKey(professionType)) {
            return mapper.get(professionType);
        } else {
            return null;
        }
    }

    /**
     * @param quality
     * @param type
     */
    private QualityMapper(String professioType, String quality, String type) {
        professionType = professioType;
        this.quality = quality;
        this.type = type;
    }

    /**
     * @return the quality
     */
    public String getQuality() {
        return quality;
    }

    /**
     * @return the type
     */
    public String getType() {
        return type;
    }

    public void addMapping(QualityMapper inMapper) {
        if (inMapper == null) {
            throw new IllegalArgumentException("Mapper is null");
        } else if (mapper.containsKey(inMapper.getType())) {
            LOG.warn("Mapping already exist, won't add this mapper");
        } else {
            mapper.put(inMapper.getType(), inMapper);
        }
    }
}
