/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.ehbox.api.domain;

import org.junit.Assert;
import org.junit.Test;


/**
 * Test class for {@link NewsMessage}.
 * 
 * @author EHP
 * 
 */
public class NewsMessageTest {

    /**
     * Test method for {@link NewsMessage#generatePublicationId()}.
     * 
     * @param <T>
     * 
     * @throws Exception
     * 
     */
    @Test
    public <T> void testGenerateNewsId() throws Exception {
        NewsMessage<T> news = new NewsMessage<T>();
        String messageId = news.getPublicationId();
        Thread.sleep(100);
        news.generatePublicationId();

        Assert.assertNull(news.getId());
        Assert.assertNotNull(news.getPublicationId());
        if (messageId.equals(news.getPublicationId())) {
            Assert.fail("generatedPublicationId failed");
        }
    }

    /**
     * Checks that default {@link NewsMessage#getId()} is not null.
     * 
     * @throws Exception
     * 
     */
    @Test
    public void testDefaultNewsId() throws Exception {
        NewsMessage<?> news = new NewsMessage<Object>();
        Assert.assertNull(news.getId());
    }

}
