/*
 * Copyright (c) Smals
 */
package be.ehealth.business.mycarenetdomaincommons.mappers;

import be.ehealth.business.mycarenetdomaincommons.builders.BlobBuilder;
import be.ehealth.business.mycarenetdomaincommons.builders.impl.BlobBuilderImpl;
import be.ehealth.business.mycarenetdomaincommons.domain.Blob;
import be.ehealth.business.mycarenetdomaincommons.exception.InvalidBlobContentConnectorException;
import be.ehealth.business.mycarenetdomaincommons.mapper.DomainBlobMapper;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import org.junit.Test;
import org.unitils.reflectionassert.ReflectionAssert;


/**
 * tests the mapping between myCarenet and genAsync objects.
 * 
 * @author EHP
 * 
 */

public class DomainBlobMapperTest {

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.genericasync.mappers.BlobMapper#mapBlob(be.ehealth.business.mycarenetdomaincommons.domain.Blob)}
     * .
     * 
     * @throws TechnicalConnectorException
     * @throws InvalidBlobContentConnectorException
     */
    @Test
    public void testMapBlob() throws InvalidBlobContentConnectorException, TechnicalConnectorException {
        BlobBuilder myCarenetBlobBuilder = new BlobBuilderImpl();
        String contentType = "text/someContentType";
        String id = "blobIdentifier";
        String encodingType = "deflate";
        byte[] bytes = "azerty".getBytes();
        Blob myCarenetBlob = myCarenetBlobBuilder.build(bytes, encodingType, id, contentType);
        String messageName = "someMessageName";
        myCarenetBlob.setMessageName(messageName);
        be.cin.types.v1.Blob mappedBlob = DomainBlobMapper.mapBlobToCinBlob(myCarenetBlob);
        be.cin.types.v1.Blob expected = new be.cin.types.v1.Blob();

        expected.setContentEncoding(encodingType);
        expected.setContentType(contentType);
        expected.setId(id);
        expected.setMessageName(messageName);
        expected.setValue(null);
        ReflectionAssert.assertLenientEquals(expected, mappedBlob);

        Blob returnedBlob = DomainBlobMapper.mapToBlob(mappedBlob);
        myCarenetBlob.setMessageName(null);
        ReflectionAssert.assertLenientEquals(myCarenetBlob, returnedBlob);
    }

}
