/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.mycarenetcommons.validator;

import org.junit.Assert;
import org.junit.Test;

import be.ehealth.business.mycarenetdomaincommons.exception.ConnectorValidationException;
import be.fgov.ehealth.mycarenet.commons.core.v3.CommonOutputType;

import static org.junit.Assert.fail;


/**
 * Test the validator of common output
 * 
 * @author EHP
 * 
 */
public class CommonOutputValidatorTest {

    @Test
    public void testSuccess() throws Exception {
        CommonOutputType commonOutput = new CommonOutputType();
        commonOutput.setInputReference("test");
        commonOutput.setNIPReference("test");
        commonOutput.setOutputReference("test");
        CommonOutputValidator.validate(commonOutput);
    }

    @Test
    public void testSuccessNullReferences() throws Exception {
        CommonOutputType commonOutput = new CommonOutputType();
        CommonOutputValidator.validate(commonOutput);
    }

    @Test
    public void testFailNullCommonOutput() throws Exception {
        try {
            CommonOutputValidator.validate((CommonOutputType) null);
        } catch (ConnectorValidationException e) {
            Assert.assertEquals(1, e.getValidationErrors().size());
            return;
        }
        fail("Validation error expected");
    }

    @Test
    public void testSuccessV2() throws Exception {
        be.fgov.ehealth.mycarenet.commons.core.v2.CommonOutputType commonOutput = new be.fgov.ehealth.mycarenet.commons.core.v2.CommonOutputType();
        commonOutput.setInputReference("test");
        commonOutput.setNIPReference("test");
        commonOutput.setOutputReference("test");
        CommonOutputValidator.validate(commonOutput);
    }

    @Test
    public void testSuccessNullReferencesV2() throws Exception {
        be.fgov.ehealth.mycarenet.commons.core.v2.CommonOutputType commonOutput = new be.fgov.ehealth.mycarenet.commons.core.v2.CommonOutputType();
        CommonOutputValidator.validate(commonOutput);
    }

    @Test
    public void testFailNullCommonOutputV2(){
        try {
            CommonOutputValidator.validate((be.fgov.ehealth.mycarenet.commons.core.v2.CommonOutputType) null);
        } catch (ConnectorValidationException e) {
            Assert.assertEquals(1, e.getValidationErrors().size());
            return;
        }
        fail("Validation error expected");
    }
    
}
