/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.common.domain;

import org.junit.Assert;
import org.junit.Test;


/**
 * tests the builder methods.
 * 
 * @author EHP
 * 
 */
public class PatientBuilderTest {

    @Test
    public void testBuilder() {
        Patient p = new Patient.Builder().withEid("eid").withMiddleName("middle").withMutuality("mut").withRegNrWithMut("reg").withFamilyName("fam").withFirstName("first").withInss("inss").withIsiPlus("isi+").withSis("sis").build();
        Assert.assertEquals("eid", p.getEidCardNumber());
        Assert.assertEquals("first", p.getFirstName());
        Assert.assertEquals("inss", p.getInss());
        Assert.assertEquals("isi+", p.getIsiCardNumber());
        Assert.assertEquals("fam", p.getLastName());
        Assert.assertEquals("middle", p.getMiddleName());
        Assert.assertEquals("mut", p.getMutuality());
        Assert.assertEquals("reg", p.getRegNrWithMut());
        Assert.assertEquals("sis", p.getSisCardNumber());
    }
}
