/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.HttpResponseSerializer;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.client.serialization.Serializer;
import org.mockserver.client.serialization.model.WebSocketMessageDTO;

public class WebSocketMessageSerializer {
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private static Map<Class, Serializer> serializers = new HashMap<Class, Serializer>();

    public String serialize(Object message) throws JsonProcessingException {
        if (serializers.containsKey(message.getClass())) {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new WebSocketMessageDTO().setType(message.getClass().getName()).setValue(serializers.get(message.getClass()).serialize(message)));
        }
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new WebSocketMessageDTO().setType(message.getClass().getName()).setValue(this.objectMapper.writeValueAsString(message)));
    }

    public Object deserialize(String messageJson) throws ClassNotFoundException, IOException {
        WebSocketMessageDTO webSocketMessageDTO = (WebSocketMessageDTO)this.objectMapper.readValue(messageJson, WebSocketMessageDTO.class);
        if (webSocketMessageDTO.getType() != null && webSocketMessageDTO.getValue() != null) {
            Class<?> format = Class.forName(webSocketMessageDTO.getType());
            if (serializers.containsKey(format)) {
                return serializers.get(format).deserialize(webSocketMessageDTO.getValue());
            }
            return this.objectMapper.readValue(webSocketMessageDTO.getValue(), format);
        }
        return null;
    }

    static {
        for (Serializer serializer : Arrays.asList(new HttpRequestSerializer(), new HttpResponseSerializer())) {
            serializers.put(serializer.supportsType(), serializer);
        }
    }
}

