/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.genins.builders;

import be.ehealth.businessconnector.genins.builders.RequestObjectBuilder;
import be.ehealth.businessconnector.genins.exception.GenInsBusinessConnectorException;
import be.ehealth.businessconnector.genins.exception.GenInsBusinessConnectorExceptionValues;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestObjectBuilderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RequestObjectBuilderFactory.class);
    private static final String PROP_REQUESTOBJECTBUILDER_CLASS = "be.ehealth.businessconnector.genins.builders.RequestObjectBuilder.class";
    private static final String DEFAULT_REQUESTOBJECTBUILDER_CLASS = "be.ehealth.businessconnector.genins.builders.impl.RequestObjectBuilderImpl";
    private static Configuration config = ConfigFactory.getConfigValidator();
    private static RequestObjectBuilder cachedBuilder;

    private RequestObjectBuilderFactory() {
    }

    public static RequestObjectBuilder getRequestObjectBuilder() throws TechnicalConnectorException, GenInsBusinessConnectorException, InstantiationException {
        if (cachedBuilder != null) {
            return cachedBuilder;
        }
        String headerClassName = config.getProperty(PROP_REQUESTOBJECTBUILDER_CLASS, DEFAULT_REQUESTOBJECTBUILDER_CLASS);
        try {
            Class<?> provider = Class.forName(headerClassName);
            if (provider != null) {
                Object providerObject = provider.newInstance();
                if (providerObject instanceof RequestObjectBuilder) {
                    cachedBuilder = (RequestObjectBuilder)providerObject;
                    return cachedBuilder;
                }
                String msg = "Class with name [" + headerClassName + "] is not an instance of RevocationStatusChecker, but an instance of [" + providerObject.getClass() + "]";
                LOG.warn(msg);
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.HEADER_INSTANCIATION, new Object[]{msg});
            }
            String msg = "Specified class [" + headerClassName + "] can't be found";
            LOG.warn(msg);
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.HEADER_INSTANCIATION, new Object[]{msg});
        }
        catch (ClassNotFoundException e) {
            String msg = "Class could not be found : " + headerClassName;
            LOG.error(msg);
            throw new GenInsBusinessConnectorException(GenInsBusinessConnectorExceptionValues.OBJECTBUILDER_INSTANCIATION_ERROR, (Throwable)e, msg);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal acces exception while instanciation of " + headerClassName;
            LOG.error(msg);
            throw new GenInsBusinessConnectorException(GenInsBusinessConnectorExceptionValues.OBJECTBUILDER_INSTANCIATION_ERROR, (Throwable)e, msg);
        }
        catch (SecurityException e) {
            String msg = "Security exception while instanciation of " + headerClassName;
            LOG.error(msg);
            throw new GenInsBusinessConnectorException(GenInsBusinessConnectorExceptionValues.OBJECTBUILDER_INSTANCIATION_ERROR, (Throwable)e, msg);
        }
        catch (IllegalArgumentException e) {
            String msg = "Illegal argument exception while instanciation of " + headerClassName;
            LOG.error(msg);
            throw new GenInsBusinessConnectorException(GenInsBusinessConnectorExceptionValues.OBJECTBUILDER_INSTANCIATION_ERROR, (Throwable)e, msg);
        }
    }
}

