/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.ocsp;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;

final class UriStreamProvider {
    private final int connectTimeout;
    private final int readTimeout;
    private final boolean isUserInteractionAllowed;

    public UriStreamProvider(int connectTimeout, int readTimeout, boolean isUserInteractionAllowed) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.isUserInteractionAllowed = isUserInteractionAllowed;
    }

    public InputStream getInputStream(URI uri) throws IOException {
        String scheme = uri.getScheme();
        if (scheme == null) {
            return this.getFileInputStream(uri);
        }
        if ("http".equals(scheme)) {
            return this.getUrlInputStream(uri);
        }
        if ("file".equals(scheme)) {
            return this.getFileInputStream(uri);
        }
        return this.getFileInputStream(uri);
    }

    private InputStream getUrlInputStream(URI uri) throws IOException {
        return this.getInputStream(uri.toURL());
    }

    private InputStream getFileInputStream(URI uri) throws FileNotFoundException {
        return new FileInputStream(uri.getPath());
    }

    public HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn != null) {
            conn.setConnectTimeout(this.connectTimeout);
            conn.setReadTimeout(this.readTimeout);
            conn.setAllowUserInteraction(this.isUserInteractionAllowed);
        }
        return conn;
    }

    public InputStream getInputStream(URL url) throws IOException {
        HttpURLConnection conn = this.getConnection(url);
        if (conn == null) {
            throw new IOException("A HTTP connection to the internet cannot be established.");
        }
        try {
            return conn.getInputStream();
        }
        catch (Exception exception) {
            throw new IOException("A stream to a HTTP connection cannot be established.", exception);
        }
    }
}

