/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.hubv3.service.impl;

import be.ehealth.business.intrahubcommons.exception.IntraHubBusinessConnectorException;
import be.ehealth.business.intrahubcommons.helper.ServiceHelper;
import be.ehealth.business.intrahubcommons.security.IntrahubEncryptionUtil;
import be.ehealth.businessconnector.hubv3.service.HubTokenService;
import be.ehealth.businessconnector.hubv3.service.ServiceFactory;
import be.ehealth.businessconnector.hubv3.util.RequestListTypeBuilder;
import be.ehealth.businessconnector.hubv3.util.RequestTypeBuilder;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.fgov.ehealth.hubservices.core.v3.DeclareTransactionRequest;
import be.fgov.ehealth.hubservices.core.v3.DeclareTransactionResponse;
import be.fgov.ehealth.hubservices.core.v3.GetAccessRightRequest;
import be.fgov.ehealth.hubservices.core.v3.GetAccessRightResponse;
import be.fgov.ehealth.hubservices.core.v3.GetHCPartyConsentRequest;
import be.fgov.ehealth.hubservices.core.v3.GetHCPartyConsentResponse;
import be.fgov.ehealth.hubservices.core.v3.GetHCPartyRequest;
import be.fgov.ehealth.hubservices.core.v3.GetHCPartyResponse;
import be.fgov.ehealth.hubservices.core.v3.GetLatestUpdateRequest;
import be.fgov.ehealth.hubservices.core.v3.GetLatestUpdateResponse;
import be.fgov.ehealth.hubservices.core.v3.GetPatientAuditTrailRequest;
import be.fgov.ehealth.hubservices.core.v3.GetPatientAuditTrailResponse;
import be.fgov.ehealth.hubservices.core.v3.GetPatientConsentRequest;
import be.fgov.ehealth.hubservices.core.v3.GetPatientConsentResponse;
import be.fgov.ehealth.hubservices.core.v3.GetPatientRequest;
import be.fgov.ehealth.hubservices.core.v3.GetPatientResponse;
import be.fgov.ehealth.hubservices.core.v3.GetTherapeuticLinkRequest;
import be.fgov.ehealth.hubservices.core.v3.GetTherapeuticLinkResponse;
import be.fgov.ehealth.hubservices.core.v3.GetTransactionListRequest;
import be.fgov.ehealth.hubservices.core.v3.GetTransactionListResponse;
import be.fgov.ehealth.hubservices.core.v3.GetTransactionRequest;
import be.fgov.ehealth.hubservices.core.v3.GetTransactionResponse;
import be.fgov.ehealth.hubservices.core.v3.GetTransactionSetRequest;
import be.fgov.ehealth.hubservices.core.v3.GetTransactionSetResponse;
import be.fgov.ehealth.hubservices.core.v3.Paginationrequestinfo;
import be.fgov.ehealth.hubservices.core.v3.PutAccessRightRequest;
import be.fgov.ehealth.hubservices.core.v3.PutAccessRightResponse;
import be.fgov.ehealth.hubservices.core.v3.PutHCPartyConsentRequest;
import be.fgov.ehealth.hubservices.core.v3.PutHCPartyConsentResponse;
import be.fgov.ehealth.hubservices.core.v3.PutHCPartyRequest;
import be.fgov.ehealth.hubservices.core.v3.PutHCPartyResponse;
import be.fgov.ehealth.hubservices.core.v3.PutPatientConsentRequest;
import be.fgov.ehealth.hubservices.core.v3.PutPatientConsentResponse;
import be.fgov.ehealth.hubservices.core.v3.PutPatientRequest;
import be.fgov.ehealth.hubservices.core.v3.PutPatientResponse;
import be.fgov.ehealth.hubservices.core.v3.PutTherapeuticLinkRequest;
import be.fgov.ehealth.hubservices.core.v3.PutTherapeuticLinkResponse;
import be.fgov.ehealth.hubservices.core.v3.PutTransactionRequest;
import be.fgov.ehealth.hubservices.core.v3.PutTransactionResponse;
import be.fgov.ehealth.hubservices.core.v3.PutTransactionSetRequest;
import be.fgov.ehealth.hubservices.core.v3.PutTransactionSetResponse;
import be.fgov.ehealth.hubservices.core.v3.RequestListType;
import be.fgov.ehealth.hubservices.core.v3.RequestPublicationRequest;
import be.fgov.ehealth.hubservices.core.v3.RequestPublicationResponse;
import be.fgov.ehealth.hubservices.core.v3.RequestType;
import be.fgov.ehealth.hubservices.core.v3.RevokeAccessRightRequest;
import be.fgov.ehealth.hubservices.core.v3.RevokeAccessRightResponse;
import be.fgov.ehealth.hubservices.core.v3.RevokeHCPartyConsentRequest;
import be.fgov.ehealth.hubservices.core.v3.RevokeHCPartyConsentResponse;
import be.fgov.ehealth.hubservices.core.v3.RevokePatientConsentRequest;
import be.fgov.ehealth.hubservices.core.v3.RevokePatientConsentResponse;
import be.fgov.ehealth.hubservices.core.v3.RevokeTherapeuticLinkRequest;
import be.fgov.ehealth.hubservices.core.v3.RevokeTherapeuticLinkResponse;
import be.fgov.ehealth.hubservices.core.v3.RevokeTransactionRequest;
import be.fgov.ehealth.hubservices.core.v3.RevokeTransactionResponse;
import javax.xml.soap.SOAPException;
import javax.xml.ws.WebServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubTokenServiceImpl
implements HubTokenService,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private static final String SOAPACTION_DECLARE_TRANSACTION = "urn:be:fgov:ehealth:intrahub:protocol:v3:DeclareTransaction";
    private static final String SOAPACTION_PUT_TRANSACTION = "urn:be:fgov:ehealth:intrahub:protocol:v3:PutTransaction";
    private static final String SOAPACTION_PUT_TRANSACTIONSET = "urn:be:fgov:ehealth:intrahub:protocol:v3:PutTransactionSet";
    private static final String SOAPACTION_REVOKE_TRANSACTION = "urn:be:fgov:ehealth:intrahub:protocol:v3:RevokeTransaction";
    private static final String SOAPACTION_GET_TRANSACTIONLIST = "urn:be:fgov:ehealth:intrahub:protocol:v3:GetTransactionList";
    private static final String SOAPACTION_GET_TRANSACTION = "urn:be:fgov:ehealth:intrahub:protocol:v3:GetTransaction";
    private static final String SOAPACTION_GET_TRANSACTIONSET = "urn:be:fgov:ehealth:intrahub:protocol:v3:GetTransactionSet";
    private static final String SOAPACTION_REQUEST_PUBLICATION = "urn:be:fgov:ehealth:intrahub:protocol:v3:RequestPublication";
    private static final String SOAPACTION_PUT_HCPARTY = "urn:be:fgov:ehealth:intrahub:protocol:v3:PutHCParty";
    private static final String SOAPACTION_GET_HCPARTY = "urn:be:fgov:ehealth:intrahub:protocol:v3:GetHCParty";
    private static final String SOAPACTION_PUT_PATIENT = "urn:be:fgov:ehealth:intrahub:protocol:v3:PutPatient";
    private static final String SOAPACTION_GET_PATIENT = "urn:be:fgov:ehealth:intrahub:protocol:v3:GetPatient";
    private static final String SOAPACTION_PUT_HCPARTYCONSENT = "urn:be:fgov:ehealth:intrahub:protocol:v3:PutHCPartyConsent";
    private static final String SOAPACTION_GET_HCPARTYCONSENT = "urn:be:fgov:ehealth:intrahub:protocol:v3:GetHCPartyConsent";
    private static final String SOAPACTION_REVOKE_HCPARTYCONSENT = "urn:be:fgov:ehealth:intrahub:protocol:v3:RevokeHCPartyConsent";
    private static final String SOAPACTION_PUT_PATIENTCONSENT = "urn:be:fgov:ehealth:intrahub:protocol:v3:PutPatientConsent";
    private static final String SOAPACTION_GET_PATIENTCONSENT = "urn:be:fgov:ehealth:intrahub:protocol:v3:GetPatientConsent";
    private static final String SOAPACTION_REVOKE_PATIENTCONSENT = "urn:be:fgov:ehealth:intrahub:protocol:v3:RevokePatientConsent";
    private static final String SOAPACTION_PUT_THERAPEUTICLINK = "urn:be:fgov:ehealth:intrahub:protocol:v3:PutTherapeuticLink";
    private static final String SOAPACTION_GET_THERAPEUTICLINK = "urn:be:fgov:ehealth:intrahub:protocol:v3:GetTherapeuticLink";
    private static final String SOAPACTION_REVOKE_THERAPEUTICLINK = "urn:be:fgov:ehealth:intrahub:protocol:v3:RevokeTherapeuticLink";
    private static final String SOAPACTION_PUT_ACCESSRIGHT = "urn:be:fgov:ehealth:intrahub:protocol:v3:PutAccessRight";
    private static final String SOAPACTION_GET_ACCESSRIGHT = "urn:be:fgov:ehealth:intrahub:protocol:v3:GetAccessRight";
    private static final String SOAPACTION_REVOKE_ACCESSRIGHT = "urn:be:fgov:ehealth:intrahub:protocol:v3:RevokeAccessRight";
    private static final String SOAPACTION_GET_PATIENTAUDIT = "urn:be:fgov:ehealth:intrahub:protocol:v3:GetPatientAuditTrail";
    private static final String SOAPACTION_GET_LASTUPDATE = "urn:be:fgov:ehealth:intrahub:protocol:v3:GetLatestUpdate";
    private static final Logger LOG = LoggerFactory.getLogger(HubTokenServiceImpl.class);

    @Override
    public DeclareTransactionResponse declareTransaction(SAMLToken token, DeclareTransactionRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_DECLARE_TRANSACTION, DeclareTransactionResponse.class);
    }

    @Override
    public PutTransactionResponse putTransaction(SAMLToken token, PutTransactionRequest request, String breakTheGlass) throws TechnicalConnectorException, IntraHubBusinessConnectorException {
        this.checkSessionCertificateExists();
        request.setRequest(this.buildKmehrRequestWithAuthorEncryptionInfo(breakTheGlass));
        MarshallerHelper helper = new MarshallerHelper(PutTransactionRequest.class, PutTransactionRequest.class);
        LOG.debug("PutTransactionRequest unsigned request :" + helper.toString((Object)request));
        return this.executeOperation(token, IntrahubEncryptionUtil.encryptFolder((Object)request, (String)"hubv3.id", (String)"hubv3.application"), SOAPACTION_PUT_TRANSACTION, PutTransactionResponse.class);
    }

    @Override
    public RevokeTransactionResponse revokeTransaction(SAMLToken token, RevokeTransactionRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_REVOKE_TRANSACTION, RevokeTransactionResponse.class);
    }

    @Override
    public GetTransactionListResponse getTransactionList(SAMLToken token, GetTransactionListRequest request, String breakTheGlass) throws TechnicalConnectorException {
        return this.getTransactionList(token, request, null, breakTheGlass);
    }

    @Override
    public GetTransactionListResponse getTransactionList(SAMLToken token, GetTransactionListRequest request, Paginationrequestinfo pagReqInfo, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest((RequestListType)RequestListTypeBuilder.init().addGenericAuthor().addPaginationInfo(pagReqInfo).addBreakTheGlass(breakTheGlass).build());
        return this.executeOperation(token, request, SOAPACTION_GET_TRANSACTIONLIST, GetTransactionListResponse.class);
    }

    @Override
    public GetTransactionResponse getTransaction(SAMLToken token, GetTransactionRequest request, String breakTheGlass) throws TechnicalConnectorException, IntraHubBusinessConnectorException {
        this.checkSessionCertificateExists();
        request.setRequest(this.buildKmehrRequestWithAuthorEncryptionInfo(breakTheGlass));
        GetTransactionRequest encryptedRequest = (GetTransactionRequest)IntrahubEncryptionUtil.encryptFolder((Object)request, (String)"hubv3.id", (String)"hubv3.application");
        return this.executeOperation(token, encryptedRequest, SOAPACTION_GET_TRANSACTION, GetTransactionResponse.class);
    }

    @Override
    public RequestPublicationResponse requestPublication(SAMLToken token, RequestPublicationRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_REQUEST_PUBLICATION, RequestPublicationResponse.class);
    }

    @Override
    public PutHCPartyResponse putHCParty(SAMLToken token, PutHCPartyRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_PUT_HCPARTY, PutHCPartyResponse.class);
    }

    @Override
    public GetHCPartyResponse getHCParty(SAMLToken token, GetHCPartyRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_GET_HCPARTY, GetHCPartyResponse.class);
    }

    @Override
    public PutPatientResponse putPatient(SAMLToken token, PutPatientRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_PUT_PATIENT, PutPatientResponse.class);
    }

    @Override
    public GetPatientResponse getPatient(SAMLToken token, GetPatientRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_GET_PATIENT, GetPatientResponse.class);
    }

    @Override
    public PutHCPartyConsentResponse putHCPartyConsent(SAMLToken token, PutHCPartyConsentRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_PUT_HCPARTYCONSENT, PutHCPartyConsentResponse.class);
    }

    @Override
    public GetHCPartyConsentResponse getHCPartyConsent(SAMLToken token, GetHCPartyConsentRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_GET_HCPARTYCONSENT, GetHCPartyConsentResponse.class);
    }

    @Override
    public RevokeHCPartyConsentResponse revokeHCPartyConsent(SAMLToken token, RevokeHCPartyConsentRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_REVOKE_HCPARTYCONSENT, RevokeHCPartyConsentResponse.class);
    }

    @Override
    public PutPatientConsentResponse putPatientConsent(SAMLToken token, PutPatientConsentRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_PUT_PATIENTCONSENT, PutPatientConsentResponse.class);
    }

    @Override
    public GetPatientConsentResponse getPatientConsent(SAMLToken token, GetPatientConsentRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_GET_PATIENTCONSENT, GetPatientConsentResponse.class);
    }

    @Override
    public RevokePatientConsentResponse revokePatientConsent(SAMLToken token, RevokePatientConsentRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_REVOKE_PATIENTCONSENT, RevokePatientConsentResponse.class);
    }

    @Override
    public PutTherapeuticLinkResponse putTherapeuticLink(SAMLToken token, PutTherapeuticLinkRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_PUT_THERAPEUTICLINK, PutTherapeuticLinkResponse.class);
    }

    @Override
    public GetTherapeuticLinkResponse getTherapeuticLink(SAMLToken token, GetTherapeuticLinkRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_GET_THERAPEUTICLINK, GetTherapeuticLinkResponse.class);
    }

    @Override
    public RevokeTherapeuticLinkResponse revokeTherapeuticLink(SAMLToken token, RevokeTherapeuticLinkRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_REVOKE_THERAPEUTICLINK, RevokeTherapeuticLinkResponse.class);
    }

    @Override
    public PutAccessRightResponse putAccessRight(SAMLToken token, PutAccessRightRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_PUT_ACCESSRIGHT, PutAccessRightResponse.class);
    }

    @Override
    public GetAccessRightResponse getAccessRight(SAMLToken token, GetAccessRightRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_GET_ACCESSRIGHT, GetAccessRightResponse.class);
    }

    @Override
    public RevokeAccessRightResponse revokeAccessRight(SAMLToken token, RevokeAccessRightRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_REVOKE_ACCESSRIGHT, RevokeAccessRightResponse.class);
    }

    @Override
    public GetPatientAuditTrailResponse getPatientAuditTrail(SAMLToken token, GetPatientAuditTrailRequest request, String breakTheGlass) throws TechnicalConnectorException {
        return this.getPatientAuditTrail(token, request, null, breakTheGlass);
    }

    @Override
    public GetPatientAuditTrailResponse getPatientAuditTrail(SAMLToken token, GetPatientAuditTrailRequest request, Paginationrequestinfo paginationrequestinfo, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest((RequestListType)RequestListTypeBuilder.init().addGenericAuthor().addPaginationInfo(paginationrequestinfo).addBreakTheGlass(breakTheGlass).build());
        return this.executeOperation(token, request, SOAPACTION_GET_PATIENTAUDIT, GetPatientAuditTrailResponse.class);
    }

    @Override
    public PutTransactionSetResponse putTransactionSet(SAMLToken token, PutTransactionSetRequest request, String breakTheGlass) throws TechnicalConnectorException, IntraHubBusinessConnectorException {
        this.checkSessionCertificateExists();
        request.setRequest(this.buildKmehrRequestWithAuthorEncryptionInfo(breakTheGlass));
        return this.executeOperation(token, IntrahubEncryptionUtil.encryptFolder((Object)request, (String)"hubv3.id", (String)"hubv3.application"), SOAPACTION_PUT_TRANSACTIONSET, PutTransactionSetResponse.class);
    }

    @Override
    public GetTransactionSetResponse getTransactionSet(SAMLToken token, GetTransactionSetRequest request, String breakTheGlass) throws TechnicalConnectorException {
        this.checkSessionCertificateExists();
        request.setRequest(this.buildKmehrRequestWithAuthorEncryptionInfo(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_GET_TRANSACTIONSET, GetTransactionSetResponse.class);
    }

    @Override
    public GetLatestUpdateResponse getLatestUpdate(SAMLToken token, GetLatestUpdateRequest request, String breakTheGlass) throws TechnicalConnectorException {
        request.setRequest(this.buildKmehrRequest(breakTheGlass));
        return this.executeOperation(token, request, SOAPACTION_GET_LASTUPDATE, GetLatestUpdateResponse.class);
    }

    private RequestType buildKmehrRequestWithAuthorEncryptionInfo(String breakTheGlass) throws TechnicalConnectorException {
        return RequestTypeBuilder.init().addAuthorWithEncryptionInformation().addBreakTheGlass(breakTheGlass).build();
    }

    private RequestType buildKmehrRequest(String breakTheGlass) throws TechnicalConnectorException {
        return RequestTypeBuilder.init().addGenericAuthor().addBreakTheGlass(breakTheGlass).build();
    }

    private <T> T executeOperation(SAMLToken token, Object request, String operation, Class<T> clazz) throws TechnicalConnectorException {
        try {
            GenericRequest service = ServiceFactory.getIntraHubPort(token, operation).setPayload(request);
            return (T)be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(service).asObject(clazz);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (WebServiceException e) {
            throw ServiceHelper.handleWebServiceException((WebServiceException)e);
        }
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{DeclareTransactionRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{DeclareTransactionResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetAccessRightRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetAccessRightResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetHCPartyConsentRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetHCPartyConsentResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetHCPartyRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetHCPartyResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetPatientAuditTrailRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetPatientAuditTrailResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetPatientConsentRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetPatientConsentResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetPatientRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetPatientResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTherapeuticLinkRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTherapeuticLinkResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTransactionListRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTransactionListResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTransactionRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTransactionResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutAccessRightRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutAccessRightResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutHCPartyConsentRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutHCPartyConsentResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutHCPartyRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutHCPartyResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutPatientConsentRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutPatientConsentResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutPatientRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutPatientResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutTherapeuticLinkRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutTherapeuticLinkResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutTransactionRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutTransactionResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RequestPublicationRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RequestPublicationResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeAccessRightRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeAccessRightResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeHCPartyConsentRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeHCPartyConsentResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokePatientConsentRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokePatientConsentResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeTherapeuticLinkRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeTherapeuticLinkResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeTransactionRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeTransactionResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetLatestUpdateRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetLatestUpdateResponse.class});
    }

    private void checkSessionCertificateExists() throws TechnicalConnectorException {
        if (SessionUtil.getEncryptionCrypto() == null) {
            LOG.error("No Personal Crypto defined... Have you created a session that also loads your Personal eHealth Certificate?");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.SECURITY_NO_CERTIFICATE, new Object[0]);
        }
    }
}

