/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.genericasync.builders.impl;

import be.cin.mycarenet.esb.common.v2.CommonInput;
import be.cin.mycarenet.esb.common.v2.OrigineType;
import be.cin.nip.async.generic.Confirm;
import be.cin.nip.async.generic.Get;
import be.cin.nip.async.generic.GetResponse;
import be.cin.nip.async.generic.MsgQuery;
import be.cin.nip.async.generic.MsgResponse;
import be.cin.nip.async.generic.Post;
import be.cin.nip.async.generic.Query;
import be.cin.nip.async.generic.QueryParameters;
import be.cin.nip.async.generic.TAckResponse;
import be.ehealth.business.mycarenetcommons.builders.util.BlobUtil;
import be.ehealth.business.mycarenetdomaincommons.builders.BlobBuilder;
import be.ehealth.business.mycarenetdomaincommons.builders.BlobBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.builders.RequestBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.domain.Blob;
import be.ehealth.business.mycarenetdomaincommons.domain.InputReference;
import be.ehealth.business.mycarenetdomaincommons.domain.async.PostContent;
import be.ehealth.business.mycarenetdomaincommons.mapper.DomainBlobMapper;
import be.ehealth.business.mycarenetdomaincommons.util.McnConfigUtil;
import be.ehealth.businessconnector.genericasync.builders.BuilderFactory;
import be.ehealth.businessconnector.genericasync.builders.RequestObjectBuilder;
import be.ehealth.businessconnector.genericasync.domain.ConfigName;
import be.ehealth.businessconnector.genericasync.encrypt.BusinessContentEncryptor;
import be.ehealth.businessconnector.genericasync.mappers.CommonInputMapper;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.validator.ValidatorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestObjectBuilderImpl
implements RequestObjectBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RequestObjectBuilderImpl.class);
    public static final String GENERICASYNC = "genericasync.";
    private static Configuration config = ConfigFactory.getConfigValidator();

    @Override
    public final Post buildPostRequest(CommonInput commonInput, be.cin.types.v1.Blob blob, byte[] xades) {
        Post post = new Post();
        post.setCommonInput(commonInput);
        post.setDetail(blob);
        if (xades != null) {
            post.setXadesT(DomainBlobMapper.mapB64fromByte((byte[])xades));
        }
        return post;
    }

    @Override
    public final Post buildPostRequest(String projectName, PostContent postContent) throws TechnicalConnectorException {
        be.cin.types.v1.Blob detail = DomainBlobMapper.mapBlobToCinBlob((Blob)postContent.getBlob());
        if (LOG.isDebugEnabled()) {
            ConnectorXmlUtils.dump((Object)detail);
        }
        Post post = new Post();
        post.setDetail(detail);
        post.setCommonInput(CommonInputMapper.mapCommonInputType(RequestBuilderFactory.getCommonBuilder((String)projectName).createCommonInput(McnConfigUtil.retrievePackageInfo((String)(GENERICASYNC + projectName)), postContent.isTest(), postContent.getCommonInputReference())));
        if (postContent.getXades() != null) {
            post.setXadesT(DomainBlobMapper.mapB64fromByte((byte[])postContent.getXades()));
        }
        return post;
    }

    @Override
    public final Get buildGetRequest(OrigineType origin, MsgQuery msgQuery, Query tackQuery) {
        Get get = new Get();
        get.setMsgQuery(msgQuery);
        get.setOrigin(origin);
        get.setTAckQuery(tackQuery);
        return get;
    }

    @Override
    public final Get buildGetRequest(OrigineType origin, MsgQuery msgQuery, Query tackQuery, QueryParameters queryParameters) {
        Get get = this.buildGetRequest(origin, msgQuery, tackQuery);
        get.setQueryParameters(queryParameters);
        return get;
    }

    @Override
    public final Get buildGetRequest(OrigineType origin, MsgQuery msgQuery, Query tackQuery, QueryParameters queryParameters, byte[] replyToEtk) {
        Get get = this.buildGetRequest(origin, msgQuery, tackQuery, queryParameters);
        get.setReplyToEtk(replyToEtk);
        return get;
    }

    @Override
    public final Get buildGetRequest(OrigineType origin, MsgQuery msgQuery, Query tackQuery, byte[] replyToEtk) {
        return this.buildGetRequest(origin, msgQuery, tackQuery, null, replyToEtk);
    }

    @Override
    public final Confirm buildConfirmRequest(OrigineType origin, List<MsgResponse> msgResponses, List<TAckResponse> tackResponses) throws TechnicalConnectorException, DataFormatException {
        ArrayList<byte[]> msgHashValues = new ArrayList<byte[]>();
        ArrayList<byte[]> tackContents = new ArrayList<byte[]>();
        if (msgResponses == null || msgResponses.isEmpty()) {
            msgHashValues.add(new byte[0]);
        } else {
            for (MsgResponse msgResponse : msgResponses) {
                msgHashValues.add(msgResponse.getDetail().getHashValue());
            }
        }
        if (tackResponses == null || tackResponses.isEmpty()) {
            tackContents.add(new byte[0]);
        } else {
            for (TAckResponse tackResponse : tackResponses) {
                tackContents.add(tackResponse.getTAck().getValue());
            }
        }
        return this.buildConfirmRequestWithHashes(origin, msgHashValues, tackContents);
    }

    @Override
    public Confirm buildConfirmRequestWithHashes(OrigineType origin, List<byte[]> msgHashValues, List<byte[]> tackContents) {
        Confirm confirm = new Confirm();
        confirm.setOrigin(origin);
        confirm.getMsgHashValues().addAll(msgHashValues);
        confirm.getTAckContents().addAll(tackContents);
        return confirm;
    }

    @Override
    public Confirm buildConfirmWithReferences(OrigineType origin, GetResponse getResponse) {
        Confirm request = new Confirm();
        request.setOrigin(origin);
        this.addTAckResponseReferencesToConfirm(getResponse, request);
        this.addMsgReferencesToConfirm(getResponse, request);
        return request;
    }

    private void addTAckResponseReferencesToConfirm(GetResponse getResponse, Confirm request) {
        for (TAckResponse tAckResponse : getResponse.getReturn().getTAckResponses()) {
            request.getTAckReferences().add(tAckResponse.getTAck().getReference());
        }
    }

    private void addMsgReferencesToConfirm(GetResponse getResponse, Confirm request) {
        for (MsgResponse msgResponse : getResponse.getReturn().getMsgResponses()) {
            request.getMsgRefValues().add(msgResponse.getDetail().getReference());
        }
    }

    @Override
    public Query createQuery(Integer max, Boolean include) {
        Query query = new Query();
        query.setInclude(include);
        query.setMax(max);
        return query;
    }

    @Override
    public MsgQuery createMsgQuery(Integer max, Boolean include, String ... messageNames) {
        MsgQuery msgQuery = new MsgQuery();
        msgQuery.setInclude(include);
        msgQuery.setMax(max);
        for (String messageName : messageNames) {
            msgQuery.getMessageNames().add(messageName);
        }
        return msgQuery;
    }

    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
    }

    @Override
    public Post buildPostRequest(String messageName, String projectName, String platformName, Object object, String schemaLocation, InputReference inputReference) throws TechnicalConnectorException {
        if (config.getBooleanProperty(GENERICASYNC + projectName + "." + messageName + ".validation.outgoing", Boolean.valueOf(true)).booleanValue()) {
            ValidatorHelper.validate((Object)object, (String)schemaLocation);
        }
        return this.buildPostRequest(messageName, projectName, platformName, ConnectorXmlUtils.toByteArray((Object)object), inputReference);
    }

    @Override
    public Post buildPostRequest(String messageName, String projectName, String platformName, byte[] xmlByteArray, InputReference inputReference) throws TechnicalConnectorException {
        return this.buildPostRequest(messageName, projectName, platformName, null, xmlByteArray, inputReference);
    }

    @Override
    public Post buildPostRequest(String messageName, String projectName, String platformName, ConfigName configName, byte[] xmlByteArray, InputReference inputReference) throws TechnicalConnectorException {
        String extraConfig = configName == null ? messageName : configName.name();
        Validate.notNull((Object)inputReference, (String)"You must define an InputReference", (Object[])new Object[0]);
        boolean encrypt = StringUtils.isNotBlank((CharSequence)config.getProperty(platformName + ".blobbuilder." + projectName + "." + extraConfig + ".contentencryption"));
        byte[] businessContent = encrypt ? BusinessContentEncryptor.encrypt(projectName, xmlByteArray, platformName, extraConfig) : xmlByteArray;
        BlobBuilder blobBuilder = BlobBuilderFactory.getBlobBuilder((String)platformName, (String)projectName, (String)extraConfig);
        Blob blob = blobBuilder.build(businessContent);
        blob.setMessageName(messageName);
        PostContent postContent = PostContent.Builder().blob(blob).commonInputReference(inputReference.getInputReference()).isTest(config.getBooleanProperty(GENERICASYNC + projectName + ".istest", Boolean.valueOf(true)).booleanValue()).messageName(messageName).xades(encrypt ? null : BlobUtil.generateXades((Blob)blob, (String)projectName, (String)platformName)).build();
        return BuilderFactory.getRequestObjectBuilder(projectName).buildPostRequest(projectName, postContent);
    }
}

