/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.ra.builders;

import be.ehealth.technicalconnector.beid.BeIDInfo;
import be.ehealth.technicalconnector.beid.domain.Identity;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.fgov.ehealth.certra.core.v2.RevocationReasonType;
import be.fgov.ehealth.technicalconnector.ra.domain.Actor;
import be.fgov.ehealth.technicalconnector.ra.domain.ActorId;
import be.fgov.ehealth.technicalconnector.ra.domain.RevocationContractRequest;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;

public final class RevocationRequestBuilder {
    private RevocationRequestBuilder() {
        throw new UnsupportedOperationException();
    }

    private static class BasicSteps
    implements PublicKeyStep,
    TypeStep,
    BuildStep {
        private byte[] publicKeyIdentifier;
        private Actor signer;
        private RevocationReasonType revocationReasonType;

        public BasicSteps() throws TechnicalConnectorException {
            Identity requestor = BeIDInfo.getInstance().getIdentity();
            this.signer = Actor.newBuilder().firstNames(Arrays.asList(requestor.getFirstName())).name(requestor.getName()).ids(Arrays.asList(ActorId.newBuilder().type(IdentifierType.SSIN.getType(48)).value(requestor.getNationalNumber()).build())).build();
        }

        @Override
        public TypeStep withPublicKeyIdentifier(byte[] publicKeyIdentifier) {
            Validate.notNull((Object)publicKeyIdentifier);
            this.publicKeyIdentifier = ArrayUtils.clone((byte[])publicKeyIdentifier);
            return this;
        }

        @Override
        public BuildStep withRevocationReasonType(RevocationReasonType revocationReasonType) {
            this.revocationReasonType = revocationReasonType;
            return this;
        }

        @Override
        public RevocationContractRequest build() throws TechnicalConnectorException {
            Validate.notNull((Object)this.publicKeyIdentifier);
            Validate.notNull((Object)this.revocationReasonType);
            Validate.notNull((Object)this.signer);
            return RevocationContractRequest.newBuilder().publicKeyIdentifier(this.publicKeyIdentifier).revocationReason(this.revocationReasonType).signer(this.signer).build();
        }
    }

    public static interface BuildStep {
        public RevocationContractRequest build() throws TechnicalConnectorException;
    }

    public static interface TypeStep {
        public BuildStep withRevocationReasonType(RevocationReasonType var1);
    }

    public static interface PublicKeyStep {
        public TypeStep withPublicKeyIdentifier(byte[] var1);
    }

    static class RevokeRequestSteps
    implements RevokeRequestBuilderStep {
        RevokeRequestSteps() {
        }

        @Override
        public PublicKeyStep create() throws TechnicalConnectorException {
            return new BasicSteps();
        }
    }

    public static interface RevokeRequestBuilderStep {
        public PublicKeyStep create() throws TechnicalConnectorException;
    }
}

