/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.sts.security.impl;

import be.ehealth.technicalconnector.cache.Cache;
import be.ehealth.technicalconnector.cache.CacheFactory;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.CredentialException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.KeyStoreFactory;
import be.ehealth.technicalconnector.service.sts.security.impl.AbstractExtendedCredential;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionServiceWithCache;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.CacheInformation;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeIDCredential
extends AbstractExtendedCredential
implements SessionServiceWithCache {
    private static final Logger LOG = LoggerFactory.getLogger(BeIDCredential.class);
    private static Cache<String, BeIDCredential> instancesMap = CacheFactory.newInstance(CacheFactory.CacheType.MEMORY, "beid-credential", CacheInformation.ExpiryType.NONE, null);
    private static ConfigValidator config = ConfigFactory.getConfigValidator();
    public static final String PROP_USE_CACHE = "be.ehealth.technicalconnector.service.sts.security.impl.beidcredential.cache";
    @Deprecated
    public static final String OID_LASTNAME = BCStyle.SURNAME.getId();
    @Deprecated
    public static final String OID_GIVENNAME = BCStyle.GIVENNAME.getId();
    @Deprecated
    public static final String OID_SERIALNUMBER = BCStyle.SN.getId();
    public static final String EID_AUTH_ALIAS = "Authentication";
    public static final String EID_SIGN_ALIAS = "Signature";
    private String eidAlias;
    private KeyStore keyStore;
    private Map<String, X509Certificate> certCache = new HashMap<String, X509Certificate>();

    private BeIDCredential(String alias) {
        this.eidAlias = alias;
        Session.getInstance().registerSessionService(this);
    }

    public static BeIDCredential getInstance(String scope, String aliasName) {
        String key = scope + "-" + aliasName;
        boolean useCache = config.getBooleanProperty(PROP_USE_CACHE, Boolean.FALSE);
        if (useCache && instancesMap.containsKey(key)) {
            LOG.debug("Returning cached instance.");
            return instancesMap.get(key);
        }
        BeIDCredential newInstance = new BeIDCredential(aliasName);
        if (useCache) {
            instancesMap.put(key, newInstance);
        }
        return newInstance;
    }

    @Override
    public PrivateKey getPrivateKey() {
        try {
            String alias = this.getAlias();
            if (!this.getKeyStore().isKeyEntry(alias)) {
                LOG.error("No Private key '{}' in the keystore", (Object)alias);
            }
            return (PrivateKey)this.getKeyStore().getKey(alias, null);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            throw new CredentialException(e);
        }
    }

    @Override
    public PublicKey getPublicKey() {
        X509Certificate cert = this.getCertificate();
        if (cert == null) {
            LOG.error("Unable to read the certificate of the EID");
            return null;
        }
        return cert.getPublicKey();
    }

    @Override
    public X509Certificate getCertificate() {
        X509Certificate certificate = null;
        try {
            String alias = this.getAlias();
            if (!this.certCache.containsKey(alias)) {
                this.certCache.put(alias, (X509Certificate)this.getKeyStore().getCertificate(alias));
            }
            certificate = this.certCache.get(alias);
        }
        catch (Exception e) {
            LOG.warn("getCertificate()", (Throwable)e);
        }
        return certificate;
    }

    private String getAlias() {
        String eidAutAlias = null;
        try {
            Enumeration<String> aliases = this.getKeyStore().aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!this.getKeyStore().isKeyEntry(alias) || !alias.equalsIgnoreCase(this.eidAlias)) continue;
                eidAutAlias = alias;
                break;
            }
        }
        catch (Exception e) {
            this.keyStore = null;
            LOG.warn("Unable to deterimine alias", (Throwable)e);
        }
        return eidAutAlias;
    }

    @Override
    public String getIssuer() {
        X509Certificate cert = this.getCertificate();
        if (cert == null) {
            LOG.error("Unable to read the certificate of the EID");
            return null;
        }
        X500Principal subject = cert.getIssuerX500Principal();
        if (subject == null) {
            LOG.error("Unable to read the SubjectDN of the EID");
            return null;
        }
        String issuer = subject.getName("RFC1779");
        this.logDebug("getIssuer: (RFC1779)" + issuer);
        return issuer;
    }

    @Override
    public String getIssuerQualifier() {
        X509Certificate cert = this.getCertificate();
        if (cert == null) {
            LOG.error("Unable to read the certificate of the EID");
            return null;
        }
        X500Principal issuerX500Principal = cert.getIssuerX500Principal();
        if (issuerX500Principal == null) {
            LOG.error("Unable to read the certificate/IssuerX500Principal of the EID");
            return null;
        }
        String issuer = issuerX500Principal.getName("RFC1779");
        this.logDebug("getIssuerQualifier: (RFC1779)" + issuer);
        return issuer;
    }

    @Override
    public KeyStore getKeyStore() throws TechnicalConnectorException {
        if (this.keyStore == null) {
            this.keyStore = KeyStoreFactory.getKeyStore();
        }
        return this.keyStore;
    }

    @Override
    public String getProviderName() {
        return this.keyStore.getProvider().getName();
    }

    private void logDebug(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message);
        }
    }

    @Override
    public void flushCache() {
        this.certCache.clear();
    }

    @Override
    public Certificate[] getCertificateChain() {
        try {
            return this.getKeyStore().getCertificateChain(this.getAlias());
        }
        catch (KeyStoreException e) {
            LOG.error(e.getMessage());
            throw new CredentialException(e);
        }
        catch (TechnicalConnectorException e) {
            LOG.error(e.getMessage());
            throw new CredentialException(e);
        }
    }
}

