/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler;

import be.ehealth.technicalconnector.handler.AbstractSOAPHandler;
import be.ehealth.technicalconnector.utils.SOAPUtils;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapActionHandler
extends AbstractSOAPHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SoapActionHandler.class);
    public static final String SOAPACTION_WSI_COMPLAINT = "be.ehealth.technicalconnector.handler.soapactionhandler.wsi.complaint";
    private static final String QUOTE = "\"";
    private static final String MIME_SOAPACTION = "SOAPAction";

    @Override
    public boolean handleOutbound(SOAPMessageContext context) {
        try {
            Boolean wsiEnabled = (Boolean)context.get((Object)SOAPACTION_WSI_COMPLAINT);
            String soapAction = (String)context.get((Object)"javax.xml.ws.soap.http.soapaction.uri");
            if (wsiEnabled == null || wsiEnabled == Boolean.TRUE) {
                LOG.debug("[WSI] compliant mode active");
                soapAction = SoapActionHandler.fixSoapAction(soapAction);
            }
            if (StringUtils.isNotBlank((String)soapAction)) {
                SoapActionHandler.addSoapAction(soapAction, context);
            }
            return true;
        }
        catch (SOAPException e) {
            throw SOAPUtils.newSOAPFaultException("WSSecurity problem: [SOAPACTION]" + e.getMessage(), e);
        }
    }

    private static void addSoapAction(String soapAction, SOAPMessageContext context) throws SOAPException {
        SOAPMessage msg = context.getMessage();
        MimeHeaders mimeHeaders = msg.getMimeHeaders();
        String[] headers = mimeHeaders.getHeader(MIME_SOAPACTION);
        if (headers != null) {
            LOG.warn("Removing SOAPAction with values: {}", (Object)ArrayUtils.toString((Object)headers));
            mimeHeaders.removeHeader(MIME_SOAPACTION);
        }
        LOG.debug("Adding mimeheader [{}] with value [{}]", (Object)MIME_SOAPACTION, (Object)soapAction);
        mimeHeaders.addHeader(MIME_SOAPACTION, soapAction);
        msg.saveChanges();
    }

    private static String fixSoapAction(String soapAction) {
        if (!org.apache.commons.lang3.StringUtils.startsWith((CharSequence)soapAction, (CharSequence)QUOTE) || !org.apache.commons.lang3.StringUtils.endsWith((CharSequence)soapAction, (CharSequence)QUOTE)) {
            LOG.debug("[WSI] R1109: SOAPACTION must be a quoted string [{}]", (Object)soapAction);
            String fixedSoapAction = org.apache.commons.lang3.StringUtils.prependIfMissing((String)soapAction, (CharSequence)QUOTE, (CharSequence[])new CharSequence[0]);
            fixedSoapAction = org.apache.commons.lang3.StringUtils.appendIfMissing((String)fixedSoapAction, (CharSequence)QUOTE, (CharSequence[])new CharSequence[0]);
            return fixedSoapAction;
        }
        return soapAction;
    }
}

