/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.shutdown.ShutdownHook;
import be.ehealth.technicalconnector.shutdown.ShutdownRegistry;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationModuleTrustStore
implements ConfigurationModule {
    public static final String SYSPROP_AUTOUPDATE_ACTIVE = "be.fgov.ehealth.technicalconnector.bootstrap.tsl.autoupdater.active";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationModuleTrustStore.class);

    @Override
    public void init(Configuration config) throws TechnicalConnectorException {
        LOG.debug("Initializing ConfigurationModule {}", (Object)this.getClass().getName());
        TrustStoreTimerEnum.TSL.name();
    }

    @Override
    public void unload() {
        LOG.debug("Unloading ConfigurationModule {}", (Object)this.getClass().getName());
    }

    private static class TrustStoreTimerTask
    extends TimerTask {
        private static final Logger LOG = LoggerFactory.getLogger(TrustStoreTimerTask.class);

        private TrustStoreTimerTask() {
        }

        @Override
        public void run() {
            try {
                MethodUtils.invokeStaticMethod(Class.forName("be.fgov.ehealth.technicalconnector.bootstrap.tsl.TrustStoreUpdater"), (String)"launch", (Object[])new Object[0]);
            }
            catch (Exception e) {
                LOG.error("Unable to update truststores", (Throwable)e);
            }
        }
    }

    private static class TrustStoreTimer
    implements ShutdownHook {
        private Timer timer;

        TrustStoreTimer() {
            if ("true".equals(System.getProperty(ConfigurationModuleTrustStore.SYSPROP_AUTOUPDATE_ACTIVE, "true"))) {
                this.timer = new Timer(true);
                this.timer.schedule((TimerTask)new TrustStoreTimerTask(), new Date(), TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS));
                ShutdownRegistry.register(this);
            }
        }

        @Override
        public void shutdown() {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
    }

    private static enum TrustStoreTimerEnum {
        TSL(new TrustStoreTimer());

        private ShutdownHook obj;

        private TrustStoreTimerEnum(ShutdownHook obj) {
            this.obj = obj;
        }

        public ShutdownHook getHook() {
            return this.obj;
        }
    }
}

