/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationModuleDefaultLanguage
implements ConfigurationModule {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationModuleDefaultLanguage.class);
    private Locale oldLocale;

    @Override
    public void init(Configuration config) {
        LOG.debug("Initializing ConfigurationModule {}", (Object)this.getClass().getName());
        String lang = config.getProperty("locale.default.lang", Locale.getDefault().getLanguage());
        LOG.info("Changing default language to: {}", (Object)lang);
        this.oldLocale = Locale.getDefault();
        Locale.setDefault(new Locale(lang));
    }

    @Override
    public void unload() {
        LOG.debug("Unloading ConfigurationModule {}", (Object)this.getClass().getName());
        Locale.setDefault(this.oldLocale);
    }
}

