/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.genericasync.builders.impl;

import be.cin.mycarenet.esb.common.v2.CommonInput;
import be.cin.mycarenet.esb.common.v2.OrigineType;
import be.cin.nip.async.generic.Confirm;
import be.cin.nip.async.generic.Get;
import be.cin.nip.async.generic.GetResponse;
import be.cin.nip.async.generic.MsgQuery;
import be.cin.nip.async.generic.MsgResponse;
import be.cin.nip.async.generic.Post;
import be.cin.nip.async.generic.Query;
import be.cin.nip.async.generic.TAckResponse;
import be.ehealth.business.mycarenetdomaincommons.builders.RequestBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.domain.Blob;
import be.ehealth.business.mycarenetdomaincommons.domain.async.PostContent;
import be.ehealth.business.mycarenetdomaincommons.mapper.DomainBlobMapper;
import be.ehealth.business.mycarenetdomaincommons.util.McnConfigUtil;
import be.ehealth.businessconnector.genericasync.builders.RequestObjectBuilder;
import be.ehealth.businessconnector.genericasync.mappers.CommonInputMapper;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;

public class RequestObjectBuilderImpl
implements RequestObjectBuilder {
    @Override
    public final Post buildPostRequest(CommonInput commonInput, be.cin.types.v1.Blob blob, byte[] xades) {
        Post post = new Post();
        post.setCommonInput(commonInput);
        post.setDetail(blob);
        if (xades != null) {
            post.setXadesT(DomainBlobMapper.mapB64fromByte((byte[])xades));
        }
        return post;
    }

    @Override
    public final Post buildPostRequest(String projectName, PostContent postContent) throws TechnicalConnectorException {
        be.cin.types.v1.Blob detail = DomainBlobMapper.mapBlobToCinBlob((Blob)postContent.getBlob());
        Post post = new Post();
        post.setDetail(detail);
        post.setCommonInput(CommonInputMapper.mapCommonInputType(RequestBuilderFactory.getCommonBuilder((String)projectName).createCommonInput(McnConfigUtil.retrievePackageInfo((String)("genericasync." + projectName)), postContent.isTest(), postContent.getCommonInputReference())));
        if (postContent.getXades() != null) {
            post.setXadesT(DomainBlobMapper.mapB64fromByte((byte[])postContent.getXades()));
        }
        return post;
    }

    @Override
    public final Get buildGetRequest(OrigineType origin, MsgQuery msgQuery, Query tackQuery) {
        Get get = new Get();
        get.setMsgQuery(msgQuery);
        get.setOrigin(origin);
        get.setTAckQuery(tackQuery);
        return get;
    }

    @Override
    public final Confirm buildConfirmRequest(OrigineType origin, List<MsgResponse> msgResponses, List<TAckResponse> tackResponses) throws TechnicalConnectorException, DataFormatException {
        ArrayList<byte[]> msgHashValues = new ArrayList<byte[]>();
        ArrayList<byte[]> tackContents = new ArrayList<byte[]>();
        if (msgResponses == null || msgResponses.isEmpty()) {
            msgHashValues.add(new byte[0]);
        } else {
            for (MsgResponse msgResponse : msgResponses) {
                msgHashValues.add(msgResponse.getDetail().getHashValue());
            }
        }
        if (tackResponses == null || tackResponses.isEmpty()) {
            tackContents.add(new byte[0]);
        } else {
            for (TAckResponse tackResponse : tackResponses) {
                tackContents.add(tackResponse.getTAck().getValue());
            }
        }
        return this.buildConfirmRequestWithHashes(origin, msgHashValues, tackContents);
    }

    @Override
    public Confirm buildConfirmRequestWithHashes(OrigineType origin, List<byte[]> msgHashValues, List<byte[]> tackContents) {
        Confirm confirm = new Confirm();
        confirm.setOrigin(origin);
        confirm.getMsgHashValues().addAll(msgHashValues);
        confirm.getTAckContents().addAll(tackContents);
        return confirm;
    }

    @Override
    public Confirm buildConfirmWithReferences(OrigineType origin, GetResponse getResponse) {
        Confirm request = new Confirm();
        request.setOrigin(origin);
        this.addTAckResponseReferencesToConfirm(getResponse, request);
        this.addMsgReferencesToConfirm(getResponse, request);
        return request;
    }

    private void addTAckResponseReferencesToConfirm(GetResponse getResponse, Confirm request) {
        for (TAckResponse tAckResponse : getResponse.getReturn().getTAckResponses()) {
            request.getTAckReferences().add(tAckResponse.getTAck().getReference());
        }
    }

    private void addMsgReferencesToConfirm(GetResponse getResponse, Confirm request) {
        for (MsgResponse msgResponse : getResponse.getReturn().getMsgResponses()) {
            request.getMsgRefValues().add(msgResponse.getDetail().getReference());
        }
    }

    @Override
    public Query createQuery(Integer max, Boolean include) {
        Query query = new Query();
        query.setInclude(include);
        query.setMax(max);
        return query;
    }

    @Override
    public MsgQuery createMsgQuery(Integer max, Boolean include, String ... messageNames) {
        MsgQuery msgQuery = new MsgQuery();
        msgQuery.setInclude(include);
        msgQuery.setMax(max);
        for (String messageName : messageNames) {
            msgQuery.getMessageNames().add(messageName);
        }
        return msgQuery;
    }

    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
    }
}

