/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.client;

import be.fedict.commons.eid.client.BeIDCard;
import be.fedict.commons.eid.client.BeIDCardManager;
import be.fedict.commons.eid.client.CancelledException;
import be.fedict.commons.eid.client.CardAndTerminalManager;
import be.fedict.commons.eid.client.OutOfCardsException;
import be.fedict.commons.eid.client.event.BeIDCardEventsListener;
import be.fedict.commons.eid.client.event.CardTerminalEventsListener;
import be.fedict.commons.eid.client.impl.LocaleManager;
import be.fedict.commons.eid.client.impl.VoidLogger;
import be.fedict.commons.eid.client.spi.BeIDCardsUI;
import be.fedict.commons.eid.client.spi.Logger;
import be.fedict.commons.eid.client.spi.Sleeper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.smartcardio.CardTerminal;

public class BeIDCards {
    private static final String UI_MISSING_LOG_MESSAGE = "No BeIDCardsUI set and can't load DefaultBeIDCardsUI";
    private static final String DEFAULT_UI_IMPLEMENTATION = "be.fedict.commons.eid.dialogs.DefaultBeIDCardsUI";
    private final Logger logger;
    private CardAndTerminalManager cardAndTerminalManager;
    private BeIDCardManager cardManager;
    private boolean terminalsInitialized;
    private boolean cardsInitialized;
    private boolean uiSelectingCard;
    private final Map<CardTerminal, BeIDCard> beIDTerminalsAndCards;
    private Sleeper terminalManagerInitSleeper;
    private Sleeper cardTerminalSleeper;
    private Sleeper cardManagerInitSleeper;
    private Sleeper beIDSleeper;
    private BeIDCardsUI ui;
    private int cardTerminalsAttached;

    public BeIDCards() {
        this(new VoidLogger(), null);
    }

    public BeIDCards(BeIDCardsUI ui) {
        this(new VoidLogger(), ui);
    }

    public BeIDCards(Logger logger) {
        this(logger, null);
    }

    public BeIDCards(Logger logger, BeIDCardsUI ui) {
        this.logger = logger;
        this.cardAndTerminalManager = new CardAndTerminalManager(logger);
        this.cardAndTerminalManager.setProtocol(CardAndTerminalManager.PROTOCOL.T0);
        this.cardManager = new BeIDCardManager(logger, this.cardAndTerminalManager);
        this.terminalManagerInitSleeper = new Sleeper();
        this.cardManagerInitSleeper = new Sleeper();
        this.cardTerminalSleeper = new Sleeper();
        this.beIDSleeper = new Sleeper();
        this.beIDTerminalsAndCards = new HashMap<CardTerminal, BeIDCard>();
        this.terminalsInitialized = false;
        this.cardsInitialized = false;
        this.uiSelectingCard = false;
        this.setUI(ui);
        this.cardAndTerminalManager.addCardTerminalListener(new CardTerminalEventsListener(){

            @Override
            public void terminalEventsInitialized() {
                BeIDCards.this.terminalsInitialized = true;
                BeIDCards.this.terminalManagerInitSleeper.awaken();
            }

            @Override
            public void terminalDetached(CardTerminal cardTerminal) {
                BeIDCards.this.cardTerminalsAttached--;
                BeIDCards.this.cardTerminalSleeper.awaken();
            }

            @Override
            public void terminalAttached(CardTerminal cardTerminal) {
                BeIDCards.this.cardTerminalsAttached++;
                BeIDCards.this.cardTerminalSleeper.awaken();
            }
        });
        this.cardManager.addBeIDCardEventListener(new BeIDCardEventsListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void eIDCardInserted(CardTerminal cardTerminal, BeIDCard card) {
                BeIDCards.this.logger.debug("eID Card Insertion Reported");
                if (BeIDCards.this.uiSelectingCard) {
                    try {
                        BeIDCards.this.getUI().eIDCardInsertedDuringSelection(card);
                    }
                    catch (Exception ex) {
                        BeIDCards.this.logger.error("Exception in UI:eIDCardInserted" + ex.getMessage());
                    }
                }
                Map map = BeIDCards.this.beIDTerminalsAndCards;
                synchronized (map) {
                    BeIDCards.this.beIDTerminalsAndCards.put(cardTerminal, card);
                    BeIDCards.this.beIDSleeper.awaken();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void eIDCardRemoved(CardTerminal cardTerminal, BeIDCard card) {
                BeIDCards.this.logger.debug("eID Card Removal Reported");
                if (BeIDCards.this.uiSelectingCard) {
                    try {
                        BeIDCards.this.getUI().eIDCardRemovedDuringSelection(card);
                    }
                    catch (Exception ex) {
                        BeIDCards.this.logger.error("Exception in UI:eIDCardRemoved" + ex.getMessage());
                    }
                }
                Map map = BeIDCards.this.beIDTerminalsAndCards;
                synchronized (map) {
                    BeIDCards.this.beIDTerminalsAndCards.remove(cardTerminal);
                    BeIDCards.this.beIDSleeper.awaken();
                }
            }

            @Override
            public void eIDCardEventsInitialized() {
                BeIDCards.this.logger.debug("eIDCardEventsInitialized");
                BeIDCards.this.cardsInitialized = true;
                BeIDCards.this.cardManagerInitSleeper.awaken();
            }
        });
        this.cardAndTerminalManager.start();
    }

    public boolean hasBeIDCards() {
        return this.hasBeIDCards(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasBeIDCards(CardTerminal terminal) {
        boolean has;
        this.waitUntilCardsInitialized();
        Map<CardTerminal, BeIDCard> map = this.beIDTerminalsAndCards;
        synchronized (map) {
            has = terminal != null ? this.beIDTerminalsAndCards.containsKey(terminal) : !this.beIDTerminalsAndCards.isEmpty();
        }
        this.logger.debug("hasBeIDCards returns " + has);
        return has;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BeIDCard> getAllBeIDCards() {
        this.waitUntilCardsInitialized();
        Map<CardTerminal, BeIDCard> map = this.beIDTerminalsAndCards;
        synchronized (map) {
            return new HashSet<BeIDCard>(this.beIDTerminalsAndCards.values());
        }
    }

    public BeIDCard getOneBeIDCard() throws CancelledException {
        return this.getOneBeIDCard(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeIDCard getOneBeIDCard(CardTerminal terminal) throws CancelledException {
        BeIDCard selectedCard = null;
        do {
            HashMap<CardTerminal, BeIDCard> currentBeIDCards;
            this.waitForAtLeastOneCardTerminal();
            this.waitForAtLeastOneBeIDCard(terminal);
            Map<CardTerminal, BeIDCard> map = this.beIDTerminalsAndCards;
            synchronized (map) {
                currentBeIDCards = new HashMap<CardTerminal, BeIDCard>(this.beIDTerminalsAndCards);
            }
            if (terminal != null) {
                selectedCard = (BeIDCard)currentBeIDCards.get(terminal);
                continue;
            }
            if (currentBeIDCards.size() == 1) {
                selectedCard = (BeIDCard)currentBeIDCards.values().iterator().next();
                continue;
            }
            try {
                this.logger.debug("selecting");
                this.uiSelectingCard = true;
                selectedCard = this.getUI().selectBeIDCard(currentBeIDCards.values());
            }
            catch (OutOfCardsException outOfCardsException) {
            }
            finally {
                this.uiSelectingCard = false;
                this.logger.debug("no longer selecting");
            }
        } while (selectedCard == null);
        return selectedCard;
    }

    public BeIDCards waitUntilCardRemoved(BeIDCard card) {
        if (this.getAllBeIDCards().contains(card)) {
            try {
                this.logger.debug("waitUntilCardRemoved blocking until card removed");
                this.getUI().adviseBeIDCardRemovalRequired();
                while (this.getAllBeIDCards().contains(card)) {
                    this.beIDSleeper.sleepUntilAwakened();
                }
            }
            finally {
                this.getUI().adviseEnd();
            }
        }
        this.logger.debug("waitUntilCardRemoved returning");
        return this;
    }

    public boolean hasCardTerminals() {
        this.waitUntilTerminalsInitialized();
        return this.cardTerminalsAttached > 0;
    }

    public BeIDCards close() throws InterruptedException {
        this.cardManager.stop();
        this.cardAndTerminalManager.stop();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeIDCards setLocale(Locale newLocale) {
        LocaleManager.setLocale(newLocale);
        Map<CardTerminal, BeIDCard> map = this.beIDTerminalsAndCards;
        synchronized (map) {
            for (BeIDCard card : this.beIDTerminalsAndCards.values()) {
                card.setLocale(newLocale);
            }
        }
        return this;
    }

    public Locale getLocale() {
        return LocaleManager.getLocale();
    }

    private void setUI(BeIDCardsUI ui) {
        this.ui = ui;
        if (this.ui != null) {
            this.setLocale(ui.getLocale());
        }
    }

    private BeIDCardsUI getUI() {
        if (this.ui == null) {
            try {
                ClassLoader classLoader = BeIDCard.class.getClassLoader();
                Class<?> uiClass = classLoader.loadClass(DEFAULT_UI_IMPLEMENTATION);
                this.setUI((BeIDCardsUI)uiClass.newInstance());
            }
            catch (Exception e) {
                this.logger.error(UI_MISSING_LOG_MESSAGE);
                throw new UnsupportedOperationException(UI_MISSING_LOG_MESSAGE, e);
            }
        }
        return this.ui;
    }

    private void waitUntilCardsInitialized() {
        while (!this.cardsInitialized) {
            this.logger.debug("Waiting for CardAndTerminalManager Cards initialisation");
            this.cardManagerInitSleeper.sleepUntilAwakened();
            this.logger.debug("CardAndTerminalManager now has cards initialized");
        }
    }

    private void waitUntilTerminalsInitialized() {
        while (!this.terminalsInitialized) {
            this.logger.debug("Waiting for CardAndTerminalManager Terminals initialisation");
            this.terminalManagerInitSleeper.sleepUntilAwakened();
            this.logger.debug("CardAndTerminalManager now has terminals initialized");
        }
    }

    private void waitForAtLeastOneBeIDCard(CardTerminal terminal) throws CancelledException {
        if (!this.hasBeIDCards(terminal)) {
            try {
                this.getUI().adviseBeIDCardRequired();
                while (!this.hasBeIDCards(terminal)) {
                    this.beIDSleeper.sleepUntilAwakened();
                }
            }
            finally {
                this.getUI().adviseEnd();
            }
        }
    }

    private void waitForAtLeastOneCardTerminal() {
        if (!this.hasCardTerminals()) {
            try {
                this.getUI().adviseCardTerminalRequired();
                while (!this.hasCardTerminals()) {
                    this.cardTerminalSleeper.sleepUntilAwakened();
                }
            }
            finally {
                this.getUI().adviseEnd();
            }
            if (!this.hasBeIDCards()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

