/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.mycarenetdomaincommons.builders.impl;

import be.ehealth.business.mycarenetdomaincommons.domain.Nihii;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.technicalconnector.tests.utils.TestPropertiesLoader;
import org.junit.Test;

import java.util.Properties;


/**
 * Create the information about the sender
 * 
 * @author EHP
 * 
 */
public class CreateSenderTest extends AbstractCommonBuilderImplTest {


    @Override
    @Test
    public void createSenderObjectWithParametersWithValidPhysicalPerson() throws Exception {
        /**
         * config for physical person mycarenet.projectName.sender.person.ssin= <br/>
         * mycarenet.projectName.sender.person.name=
         */

        Properties properties = TestPropertiesLoader.getProperties("/be.ehealth.businessconnector.mycarenetdomaincommons.test.properties");
        String name = properties.getProperty(PROP_EXAMPLE_NAME);
        String ssin = properties.getProperty(PROP_EXAMPLE_NISS);
        setSenderOrganizationProperties(null, null, null);
        setSenderPhysicalPersonProperties(name, ssin);
        testCreateSenderForOriginPhysicalPerson(name, ssin);
    }


    @Test(expected = TechnicalConnectorException.class)
    public void createSenderObjectWithParametersWithPhysicalPersonNoSsin() throws Exception {
        /**
         * config for physical person mycarenet.projectName.sender.person.ssin=SeePropertyFile <br/>
         * mycarenet.projectName.sender.person.name=Bart Van Haute
         */

        String name = "Bart Van Haute";
        setSenderOrganizationProperties(null, null, null);
        setSenderPhysicalPersonProperties(name, null);
        testCreateSenderForOriginPhysicalPerson(name, null);

        builder.createSenderForOrigin();
    }


    @Test
    public void createSenderObjectWithParametersWithPhysicalPersonNoName() throws Exception {
        /**
         * config for physical person mycarenet.projectName.sender.person.ssin=SeePropertyFile <br/>
         * mycarenet.projectName.sender.person.name=Bart Van Haute
         */

        Properties properties = TestPropertiesLoader.getProperties("/be.ehealth.businessconnector.mycarenetdomaincommons.test.properties");
        String ssin = properties.getProperty(PROP_EXAMPLE_NISS);
        setSenderOrganizationProperties(null, null, null);
        setSenderPhysicalPersonProperties(null, ssin);
        testCreateSenderForOriginPhysicalPerson(null, ssin);

        builder.createSenderForOrigin();
    }


    @Test
    public void createSenderObjectWithParametersWithValidorganization() throws Exception {
        /**
         * config for enterprise : mycarenet.projectName.sender.organization.cbe=someCbeNumber
         */

        String cbe = "someCbeNumber";
        setSenderPhysicalPersonProperties(null, null);
        setSenderOrganizationProperties(null, null, cbe);
        testCreateSenderForOriginOrganization(null, null, cbe);
    }


    @Test
    public void createSenderObjectWithParametersWithValidNihiiorganization() throws Exception {
        /**
         * config for other enterprise with nihii numer mycarenet.projectName.sender.organization.nihii=4646464646
         */

        String value = "4646464646";
        String quality = "hcparty";
        setSenderPhysicalPersonProperties(null, null);
        setSenderOrganizationProperties(null, new Nihii(quality, value), null);
        testCreateSenderForOriginOrganization(null, new Nihii(quality, value), null);

        builder.createSenderForOrigin();
    }


}
