/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehbox.v3.validator.impl;

import be.ehealth.businessconnector.ehbox.v3.exception.OoOPublicationException;
import be.ehealth.businessconnector.ehbox.v3.validator.EhboxReplyValidator;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.fgov.ehealth.commons.core.v1.LocalisedString;
import be.fgov.ehealth.commons.protocol.v1.ResponseType;
import be.fgov.ehealth.ehbox.core.v3.BoxIdType;
import be.fgov.ehealth.ehbox.publication.protocol.v3.Recipient;
import be.fgov.ehealth.ehbox.publication.protocol.v3.SendMessageResponse;
import be.fgov.ehealth.ehbox.publication.protocol.v3.Substitute;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhboxReplyValidatorImpl
implements EhboxReplyValidator {
    private static final Logger LOG = LoggerFactory.getLogger(EhboxReplyValidatorImpl.class);
    public static final String EHEALTH_SUCCESS_CODE_100 = "100";
    public static final String EHEALTH_SUCCESS_CODE_200 = "200";
    public static final String EHBOX_OOO_EXCEPTION = "826";

    @Override
    public boolean validateReplyStatus(ResponseType response) throws ConnectorException {
        if (EHEALTH_SUCCESS_CODE_100.equals(response.getStatus().getCode()) || EHEALTH_SUCCESS_CODE_200.equals(response.getStatus().getCode())) {
            return true;
        }
        if (EHBOX_OOO_EXCEPTION.equals(response.getStatus().getCode())) {
            if (response instanceof SendMessageResponse) {
                SendMessageResponse messageResponse = (SendMessageResponse)response;
                HashMap<BoxIdType, List<Substitute>> oooInformation = new HashMap<BoxIdType, List<Substitute>>();
                for (Recipient recipient : messageResponse.getRecipients()) {
                    if (recipient.getAbsentFrom() == null) continue;
                    BoxIdType receiver = new BoxIdType();
                    receiver.setId(recipient.getId());
                    receiver.setQuality(recipient.getQuality());
                    receiver.setType(recipient.getType());
                    receiver.setSubType(recipient.getSubType());
                    oooInformation.put(receiver, recipient.getSubstitutes());
                }
                throw new OoOPublicationException(TechnicalConnectorExceptionValues.ERROR_WS.getMessage(), EHBOX_OOO_EXCEPTION, oooInformation);
            }
            throw this.generateError(response);
        }
        throw this.generateError(response);
    }

    private TechnicalConnectorException generateError(ResponseType response) {
        StringBuilder reasonBuilder = new StringBuilder("Received Code[");
        reasonBuilder.append(response.getStatus().getCode());
        reasonBuilder.append("] Reason: ");
        for (LocalisedString localisedString : response.getStatus().getMessages()) {
            reasonBuilder.append(" ").append(localisedString.getValue());
        }
        LOG.error(reasonBuilder.toString());
        return new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{reasonBuilder.toString()});
    }
}

