/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.bootstrap.bcp.parser;

import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.EndPointInformation;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.ArrayUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class StatusPageParser {
    private static final String NS_BCP = "urn:be:fgov:ehealth:bcp:protocol:v1";
    private static final QName QNAME_SERVICE = new QName("urn:be:fgov:ehealth:bcp:protocol:v1", "Service");
    private static final QName QNAME_ENDPOINT = new QName("urn:be:fgov:ehealth:bcp:protocol:v1", "Endpoint");

    private StatusPageParser() {
        throw new UnsupportedOperationException();
    }

    public static EndPointInformation parse(String xml) throws TechnicalConnectorException {
        ByteArrayInputStream is = new ByteArrayInputStream(ConnectorIOUtils.toBytes((String)xml, (Charset)Charset.UTF_8));
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            SaxHandler handler = new SaxHandler();
            saxParser.parse((InputStream)is, (DefaultHandler)handler);
            return handler.getInfo();
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_TECHNICAL, (Throwable)e, new Object[0]);
        }
    }

    static class SaxHandler
    extends DefaultHandler {
        private EndPointInformation info = new EndPointInformation();
        private String serviceName;
        private String activeEndpoint;
        private String defaultEnpoint;
        private Map<Integer, String> endpoints = new TreeMap<Integer, String>();
        private Integer order;
        private boolean active;
        private String endpoint;

        SaxHandler() {
        }

        public EndPointInformation getInfo() {
            return this.info;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (StatusPageParser.NS_BCP.equals(uri)) {
                if (localName.equals(QNAME_SERVICE.getLocalPart())) {
                    this.serviceName = attributes.getValue("", "Id");
                    this.endpoints.clear();
                } else if (localName.equals(QNAME_ENDPOINT.getLocalPart())) {
                    this.order = Integer.parseInt(attributes.getValue("", "Order"));
                    this.active = "ACTIVE".equals(attributes.getValue("", "Status"));
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.endpoint = new String(ArrayUtils.clone((char[])ch), start, length).trim();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (StatusPageParser.NS_BCP.equals(uri)) {
                if (localName.equals(QNAME_SERVICE.getLocalPart())) {
                    this.info.register(this.serviceName, this.activeEndpoint, this.defaultEnpoint, this.endpoints.values());
                    this.activeEndpoint = null;
                } else if (localName.equals(QNAME_ENDPOINT.getLocalPart())) {
                    this.endpoints.put(this.order, this.endpoint);
                    if (this.active) {
                        this.activeEndpoint = this.endpoint;
                    }
                    if (this.order.equals(0)) {
                        this.defaultEnpoint = this.endpoint;
                    }
                    this.active = false;
                }
            }
        }
    }
}

